/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.loading;

import java.lang.reflect.Array;
import java.util.Arrays;

public final class RadixSort {
    private static final int RADIX = 8;
    private static final int HIST_SIZE = 256;

    public static int[] newHistogram(int length) {
        return new int[Math.max(length, 257)];
    }

    public static long[] newCopy(long[] data) {
        return new long[data.length];
    }

    public static <T> T[] newCopy(T[] data) {
        return (Object[])Array.newInstance(data.getClass().getComponentType(), data.length);
    }

    public static <T> void radixSort(long[] data, long[] dataCopy, long[] additionalData1, long[] additionalCopy1, T[] additionalData2, T[] additionalCopy2, int[] histogram, int length) {
        RadixSort.radixSort(data, dataCopy, additionalData1, additionalCopy1, additionalData2, additionalCopy2, histogram, length, 0);
    }

    private static <T> void radixSort(long[] data, long[] dataCopy, long[] additionalData1, long[] additionalCopy1, T[] additionalData2, T[] additionalCopy2, int[] histogram, int length, int shift) {
        int hlen = Math.min(256, histogram.length - 1);
        int dlen = Math.min(length, Math.min(data.length, dataCopy.length));
        long loMask = 255L << shift;
        long hiMask = -(256L << shift);
        while (shift < 64) {
            int i;
            Arrays.fill(histogram, 0, 1 + hlen, 0);
            int maxHistIndex = 0;
            long hiBits = 0L;
            for (i = 0; i < dlen; i += 2) {
                hiBits |= data[i] & hiMask;
                int histIndex = (int)((data[i] & loMask) >>> shift);
                maxHistIndex |= histIndex;
                int n = 1 + histIndex;
                histogram[n] = histogram[n] + 2;
            }
            if (hiBits == 0L && maxHistIndex == 0) {
                return;
            }
            if (maxHistIndex != 0) {
                for (i = 0; i < hlen; ++i) {
                    int n = i + 1;
                    histogram[n] = histogram[n] + histogram[i];
                }
                for (i = 0; i < dlen; i += 2) {
                    int n = (int)((data[i] & loMask) >>> shift);
                    int n2 = histogram[n] + 2;
                    histogram[n] = n2;
                    int out = n2;
                    dataCopy[out - 2] = data[i];
                    dataCopy[out - 1] = data[1 + i];
                    additionalCopy1[(out - 2) / 2] = additionalData1[i / 2];
                    additionalCopy2[(out - 2) / 2] = additionalData2[i / 2];
                }
                System.arraycopy(dataCopy, 0, data, 0, dlen);
                System.arraycopy(additionalCopy1, 0, additionalData1, 0, dlen / 2);
                System.arraycopy(additionalCopy2, 0, additionalData2, 0, dlen / 2);
            }
            shift += 8;
            loMask <<= 8;
            hiMask <<= 8;
        }
    }

    public static <T> void radixSort2(long[] data, long[] dataCopy, long[] additionalData1, long[] additionalCopy1, T[] additionalData2, T[] additionalCopy2, int[] histogram, int length) {
        RadixSort.radixSort2(data, dataCopy, additionalData1, additionalCopy1, additionalData2, additionalCopy2, histogram, length, 0);
    }

    private static <T> void radixSort2(long[] data, long[] dataCopy, long[] additionalData1, long[] additionalCopy1, T[] additionalData2, T[] additionalCopy2, int[] histogram, int length, int shift) {
        int i;
        int hlen = Math.min(256, histogram.length - 1);
        int dlen = Math.min(length, Math.min(data.length, dataCopy.length));
        Arrays.fill(histogram, 0, hlen, 0);
        long loMask = 255L << shift;
        for (i = 0; i < dlen; i += 2) {
            int n = 1 + (int)((data[1 + i] & loMask) >>> shift);
            histogram[n] = histogram[n] + 2;
        }
        for (i = 0; i < hlen; ++i) {
            int n = i + 1;
            histogram[n] = histogram[n] + histogram[i];
        }
        for (int i2 = 0; i2 < dlen; i2 += 2) {
            int n = (int)((data[1 + i2] & loMask) >>> shift);
            int n2 = histogram[n] + 2;
            histogram[n] = n2;
            int out = n2;
            dataCopy[out - 2] = data[1 + i2];
            dataCopy[out - 1] = data[i2];
            additionalCopy1[(out - 2) / 2] = additionalData1[i2 / 2];
            additionalCopy2[(out - 2) / 2] = additionalData2[i2 / 2];
        }
        System.arraycopy(dataCopy, 0, data, 0, dlen);
        System.arraycopy(additionalCopy1, 0, additionalData1, 0, dlen / 2);
        System.arraycopy(additionalCopy2, 0, additionalData2, 0, dlen / 2);
        RadixSort.radixSort(data, dataCopy, additionalData1, additionalCopy1, additionalData2, additionalCopy2, histogram, length, shift + 8);
    }

    private RadixSort() {
    }
}

