/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.loading;

import java.util.Arrays;
import org.neo4j.gds.compat.Neo4jProxy;
import org.neo4j.gds.compat.PropertyReference;
import org.neo4j.gds.core.Aggregation;
import org.neo4j.gds.core.loading.ReadHelper;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.kernel.api.KernelTransaction;

public interface PropertyReader {
    public long[][] readProperty(long[] var1, PropertyReference[] var2, int var3, int[] var4, double[] var5, Aggregation[] var6, boolean var7);

    public static PropertyReader preLoaded() {
        return (relationshipReferences, propertyReferences, numberOfReferences, weightProperty, defaultWeight, aggregations, atLeastOnePropertyToLoad) -> {
            long[] properties = Arrays.copyOf(relationshipReferences, numberOfReferences);
            return new long[][]{properties};
        };
    }

    public static PropertyReader storeBacked(KernelTransaction kernelTransaction) {
        return (relationshipReferences, propertyReferences, numberOfReferences, relationshipProperties, defaultPropertyValues, aggregations, atLeastOnePropertyToLoad) -> {
            long[][] properties = new long[relationshipProperties.length][numberOfReferences];
            if (atLeastOnePropertyToLoad) {
                try (PropertyCursor pc = Neo4jProxy.allocatePropertyCursor((KernelTransaction)kernelTransaction);){
                    double[] relProps = new double[relationshipProperties.length];
                    for (int i = 0; i < numberOfReferences; ++i) {
                        Neo4jProxy.relationshipProperties((KernelTransaction)kernelTransaction, (long)relationshipReferences[i], (PropertyReference)propertyReferences[i], (PropertyCursor)pc);
                        ReadHelper.readProperties(pc, relationshipProperties, defaultPropertyValues, aggregations, relProps);
                        for (int j = 0; j < relProps.length; ++j) {
                            properties[j][i] = Double.doubleToLongBits(relProps[j]);
                        }
                    }
                }
            } else {
                for (int i = 0; i < numberOfReferences; ++i) {
                    for (int j = 0; j < defaultPropertyValues.length; ++j) {
                        double value = aggregations[j].normalizePropertyValue(defaultPropertyValues[j]);
                        properties[j][i] = Double.doubleToLongBits(value);
                    }
                }
            }
            return properties;
        };
    }

    public static Buffered buffered(int batchSize, int propertyCount) {
        return new Buffered(batchSize, propertyCount);
    }

    public static class Buffered
    implements PropertyReader {
        private final long[][] buffer;
        private final int propertyCount;

        Buffered(int batchSize, int propertyCount) {
            this.propertyCount = propertyCount;
            this.buffer = new long[propertyCount][batchSize];
        }

        public void add(int relationshipId, int propertyKeyId, double property) {
            this.buffer[propertyKeyId][relationshipId] = Double.doubleToLongBits(property);
        }

        @Override
        public long[][] readProperty(long[] relationshipReferences, PropertyReference[] propertyReferences, int numberOfReferences, int[] propertyKeyIds, double[] defaultValues, Aggregation[] aggregations, boolean atLeastOnePropertyToLoad) {
            long[][] resultBuffer = new long[this.propertyCount][numberOfReferences];
            for (int propertyKeyId = 0; propertyKeyId < this.propertyCount; ++propertyKeyId) {
                long[] propertyValues = new long[numberOfReferences];
                for (int relationshipOffset = 0; relationshipOffset < numberOfReferences; ++relationshipOffset) {
                    int relationshipId = (int)relationshipReferences[relationshipOffset];
                    propertyValues[relationshipOffset] = this.buffer[propertyKeyId][relationshipId];
                }
                resultBuffer[propertyKeyId] = propertyValues;
            }
            return resultBuffer;
        }
    }
}

