/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.loading;

import java.util.OptionalDouble;
import java.util.OptionalLong;
import org.neo4j.gds.api.nodeproperties.ValueType;
import org.neo4j.gds.api.properties.nodes.LongNodePropertyValues;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public abstract class NullPropertyMap
implements NodePropertyValues {

    public static class LongNullPropertyMap
    extends NullPropertyMap
    implements LongNodePropertyValues {
        private final long defaultValue;

        public LongNullPropertyMap(long defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        public long longValue(long nodeId) {
            return this.defaultValue;
        }

        @Override
        public Object getObject(long nodeId) {
            return this.longValue(nodeId);
        }

        @Override
        public Value value(long nodeId) {
            return Values.longValue((long)this.defaultValue);
        }

        @Override
        public OptionalLong getMaxLongPropertyValue() {
            return OptionalLong.empty();
        }

        @Override
        public ValueType valueType() {
            return ValueType.LONG;
        }

        @Override
        public long size() {
            return 0L;
        }
    }

    public static class DoubleNullPropertyMap
    extends NullPropertyMap {
        private final double defaultValue;

        public DoubleNullPropertyMap(double defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        public double doubleValue(long nodeId) {
            return this.defaultValue;
        }

        @Override
        public Object getObject(long nodeId) {
            return this.doubleValue(nodeId);
        }

        @Override
        public Value value(long nodeId) {
            return Values.doubleValue((double)this.defaultValue);
        }

        @Override
        public ValueType valueType() {
            return ValueType.DOUBLE;
        }

        @Override
        public OptionalDouble getMaxDoublePropertyValue() {
            return OptionalDouble.empty();
        }

        @Override
        public long size() {
            return 0L;
        }
    }
}

