/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.loading;

import java.util.Arrays;
import org.apache.commons.lang3.mutable.MutableDouble;
import org.neo4j.gds.core.loading.DoubleCodec;
import org.neo4j.gds.core.loading.ImmutableCompressionInfo;

public final class NoopDoubleCodec
extends DoubleCodec {
    private static final DoubleCodec INSTANCE = new NoopDoubleCodec();

    public static DoubleCodec instance() {
        return INSTANCE;
    }

    @Override
    public int compressDouble(long doubleBits, byte[] out, int outPos) {
        out[0 + outPos] = (byte)(doubleBits >>> 56 & 0xFFL);
        out[1 + outPos] = (byte)(doubleBits >>> 48 & 0xFFL);
        out[2 + outPos] = (byte)(doubleBits >>> 40 & 0xFFL);
        out[3 + outPos] = (byte)(doubleBits >>> 32 & 0xFFL);
        out[4 + outPos] = (byte)(doubleBits >>> 24 & 0xFFL);
        out[5 + outPos] = (byte)(doubleBits >>> 16 & 0xFFL);
        out[6 + outPos] = (byte)(doubleBits >>> 8 & 0xFFL);
        out[7 + outPos] = (byte)(doubleBits >>> 0 & 0xFFL);
        return 8 + outPos;
    }

    @Override
    public int decompressDouble(byte[] data, int pos, MutableDouble out) {
        long bits = (long)(data[0 + pos] & 0xFF) << 56 | (long)(data[1 + pos] & 0xFF) << 48 | (long)(data[2 + pos] & 0xFF) << 40 | (long)(data[3 + pos] & 0xFF) << 32 | (long)(data[4 + pos] & 0xFF) << 24 | (long)(data[5 + pos] & 0xFF) << 16 | (long)(data[6 + pos] & 0xFF) << 8 | (long)(data[7 + pos] & 0xFF) << 0;
        out.setValue(Double.longBitsToDouble(bits));
        return 8 + pos;
    }

    @Override
    public int compressedSize(byte[] data, int pos) {
        return 8;
    }

    @Override
    public String describeCompression(int type) {
        return "NOOP";
    }

    @Override
    public DoubleCodec.CompressionInfo describeCompressedValue(byte[] data, int pos, double originalInput) {
        return ImmutableCompressionInfo.builder().input(originalInput).compressed(Arrays.copyOfRange(data, pos, 8 + pos)).decompressed(this.decompressDouble(data, pos)).compressedSize(8).compressedType(0).compressionDescription("NOOP").build();
    }

    private NoopDoubleCodec() {
    }
}

