/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.loading;

import com.carrotsearch.hppc.LongSet;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.core.loading.AdjacencyBuffer;
import org.neo4j.gds.core.loading.NativeNodePropertyImporter;
import org.neo4j.gds.core.loading.NodeImporter;
import org.neo4j.gds.core.loading.NodeReference;
import org.neo4j.gds.core.loading.NodesBatchBuffer;
import org.neo4j.gds.core.loading.NodesBatchBufferBuilder;
import org.neo4j.gds.core.loading.RecordScannerTask;
import org.neo4j.gds.core.loading.RecordScannerTaskRunner;
import org.neo4j.gds.core.loading.StoreScanner;
import org.neo4j.gds.core.utils.RawValues;
import org.neo4j.gds.core.utils.StatementAction;
import org.neo4j.gds.core.utils.TerminationFlag;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.transaction.TransactionContext;
import org.neo4j.kernel.api.KernelTransaction;

public final class NodesScannerTask
extends StatementAction
implements RecordScannerTask {
    private final TerminationFlag terminationFlag;
    private final StoreScanner<NodeReference> scanner;
    private final long highestPossibleNodeCount;
    private final LongSet labels;
    private final int taskIndex;
    private final ProgressTracker progressTracker;
    private final NodeImporter importer;
    private final NativeNodePropertyImporter nodePropertyImporter;
    private long propertiesImported;
    private long nodesImported;

    private NodesScannerTask(TransactionContext tx, TerminationFlag terminationFlag, StoreScanner<NodeReference> scanner, long highestPossibleNodeCount, LongSet labels, int taskIndex, ProgressTracker progressTracker, NodeImporter importer, @Nullable NativeNodePropertyImporter nodePropertyImporter) {
        super(tx);
        this.terminationFlag = terminationFlag;
        this.scanner = scanner;
        this.highestPossibleNodeCount = highestPossibleNodeCount;
        this.labels = labels;
        this.taskIndex = taskIndex;
        this.progressTracker = progressTracker;
        this.importer = importer;
        this.nodePropertyImporter = nodePropertyImporter;
    }

    @Override
    public String threadName() {
        return "node-store-scan-" + this.taskIndex;
    }

    @Override
    public void accept(KernelTransaction transaction) {
        try (StoreScanner.ScanCursor<NodeReference> cursor = this.scanner.createCursor(transaction);){
            NodesBatchBuffer nodesBatchBuffer = new NodesBatchBufferBuilder().highestPossibleNodeCount(this.highestPossibleNodeCount).nodeLabelIds(this.labels).capacity(this.scanner.bufferSize()).hasLabelInformation(this.labels.size() > 1).readProperty(this.nodePropertyImporter != null).build();
            while (nodesBatchBuffer.scan(cursor)) {
                this.terminationFlag.assertRunning();
                long imported = this.importNodes(nodesBatchBuffer, transaction, this.nodePropertyImporter);
                int batchImportedNodes = RawValues.getHead(imported);
                int batchImportedProperties = RawValues.getTail(imported);
                this.progressTracker.logProgress(batchImportedNodes);
                this.nodesImported += (long)batchImportedNodes;
                this.propertiesImported += (long)batchImportedProperties;
            }
        }
    }

    @Override
    public long propertiesImported() {
        return this.propertiesImported;
    }

    @Override
    public long recordsImported() {
        return this.nodesImported;
    }

    private long importNodes(NodesBatchBuffer buffer, KernelTransaction kernelTransaction, @Nullable NativeNodePropertyImporter propertyImporter) {
        return this.importer.importNodes(buffer, (nodeReference, labelIds, propertiesReference) -> {
            if (propertyImporter != null) {
                return propertyImporter.importProperties(nodeReference, labelIds, propertiesReference, kernelTransaction);
            }
            return 0;
        });
    }

    public static RecordScannerTaskRunner.RecordScannerTaskFactory factory(TransactionContext tx, StoreScanner<NodeReference> scanner, long highestPossibleNodeCount, LongSet labels, ProgressTracker progressTracker, NodeImporter nodeImporter, @Nullable NativeNodePropertyImporter nodePropertyImporter, TerminationFlag terminationFlag) {
        return new Factory(tx, scanner, highestPossibleNodeCount, labels, progressTracker, nodeImporter, nodePropertyImporter, terminationFlag);
    }

    static final class Factory
    implements RecordScannerTaskRunner.RecordScannerTaskFactory {
        private final TransactionContext tx;
        private final StoreScanner<NodeReference> scanner;
        private final long highestPossibleNodeCount;
        private final LongSet labels;
        private final ProgressTracker progressTracker;
        private final NodeImporter nodeImporter;
        private final NativeNodePropertyImporter nodePropertyImporter;
        private final TerminationFlag terminationFlag;

        Factory(TransactionContext tx, StoreScanner<NodeReference> scanner, long highestPossibleNodeCount, LongSet labels, ProgressTracker progressTracker, NodeImporter nodeImporter, @Nullable NativeNodePropertyImporter nodePropertyImporter, TerminationFlag terminationFlag) {
            this.tx = tx;
            this.scanner = scanner;
            this.highestPossibleNodeCount = highestPossibleNodeCount;
            this.labels = labels;
            this.progressTracker = progressTracker;
            this.nodeImporter = nodeImporter;
            this.nodePropertyImporter = nodePropertyImporter;
            this.terminationFlag = terminationFlag;
        }

        @Override
        public RecordScannerTask create(int taskIndex) {
            return new NodesScannerTask(this.tx, this.terminationFlag, this.scanner, this.highestPossibleNodeCount, this.labels, taskIndex, this.progressTracker, this.nodeImporter, this.nodePropertyImporter);
        }

        @Override
        public Collection<AdjacencyBuffer.AdjacencyListBuilderTask> adjacencyListBuilderTasks() {
            return Collections.emptyList();
        }
    }
}

