/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.loading;

import com.carrotsearch.hppc.LongSet;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.neo4j.gds.core.loading.NodesBatchBuffer;

@ParametersAreNonnullByDefault
@Generated(from="org.neo4j.gds.core.loading.NodesBatchBuffer", generator="Immutables")
@SuppressFBWarnings
@NotThreadSafe
public final class NodesBatchBufferBuilder {
    private static final long INIT_BIT_CAPACITY = 1L;
    private static final long INIT_BIT_HIGHEST_POSSIBLE_NODE_COUNT = 2L;
    private long initBits = 3L;
    private int capacity;
    private long highestPossibleNodeCount;
    private Optional<LongSet> nodeLabelIds = Optional.empty();
    private Optional<Boolean> hasLabelInformation = Optional.empty();
    private Optional<Boolean> readProperty = Optional.empty();

    public final NodesBatchBufferBuilder capacity(int capacity) {
        this.capacity = capacity;
        this.initBits &= 0xFFFFFFFFFFFFFFFEL;
        return this;
    }

    public final NodesBatchBufferBuilder highestPossibleNodeCount(long highestPossibleNodeCount) {
        this.highestPossibleNodeCount = highestPossibleNodeCount;
        this.initBits &= 0xFFFFFFFFFFFFFFFDL;
        return this;
    }

    public final NodesBatchBufferBuilder nodeLabelIds(LongSet nodeLabelIds) {
        this.nodeLabelIds = Optional.of(nodeLabelIds);
        return this;
    }

    public final NodesBatchBufferBuilder nodeLabelIds(Optional<? extends LongSet> nodeLabelIds) {
        this.nodeLabelIds = Objects.requireNonNull(nodeLabelIds, "nodeLabelIds");
        return this;
    }

    public final NodesBatchBufferBuilder hasLabelInformation(boolean hasLabelInformation) {
        this.hasLabelInformation = Optional.of(hasLabelInformation);
        return this;
    }

    public final NodesBatchBufferBuilder hasLabelInformation(Optional<Boolean> hasLabelInformation) {
        this.hasLabelInformation = Objects.requireNonNull(hasLabelInformation, "hasLabelInformation");
        return this;
    }

    public final NodesBatchBufferBuilder readProperty(boolean readProperty) {
        this.readProperty = Optional.of(readProperty);
        return this;
    }

    public final NodesBatchBufferBuilder readProperty(Optional<Boolean> readProperty) {
        this.readProperty = Objects.requireNonNull(readProperty, "readProperty");
        return this;
    }

    public NodesBatchBuffer build() {
        this.checkRequiredAttributes();
        return new NodesBatchBuffer(this.capacity, this.highestPossibleNodeCount, this.nodeLabelIds, this.hasLabelInformation, this.readProperty);
    }

    private boolean capacityIsSet() {
        return (this.initBits & 1L) == 0L;
    }

    private boolean highestPossibleNodeCountIsSet() {
        return (this.initBits & 2L) == 0L;
    }

    private void checkRequiredAttributes() {
        if (this.initBits != 0L) {
            throw new IllegalStateException(this.formatRequiredAttributesMessage());
        }
    }

    private String formatRequiredAttributesMessage() {
        ArrayList<String> attributes = new ArrayList<String>();
        if (!this.capacityIsSet()) {
            attributes.add("capacity");
        }
        if (!this.highestPossibleNodeCountIsSet()) {
            attributes.add("highestPossibleNodeCount");
        }
        return "Cannot build NodesBatchBuffer, some of required attributes are not set " + attributes;
    }
}

