/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.loading;

import com.carrotsearch.hppc.LongHashSet;
import com.carrotsearch.hppc.LongSet;
import java.util.Optional;
import org.immutables.builder.Builder;
import org.neo4j.gds.compat.Neo4jProxy;
import org.neo4j.gds.compat.PropertyReference;
import org.neo4j.gds.core.loading.NodeReference;
import org.neo4j.gds.core.loading.RecordsBatchBuffer;
import org.neo4j.gds.utils.GdsFeatureToggles;

public final class NodesBatchBuffer
extends RecordsBatchBuffer<NodeReference> {
    private static final long[] ANY_LABEL_LABELS = new long[]{-1L};
    private final long highestPossibleNodeCount;
    private final LongSet nodeLabelIds;
    private final boolean hasLabelInformation;
    private final long[][] labelIds;
    private final boolean skipOrphans;
    private final PropertyReference[] properties;

    @Builder.Constructor
    NodesBatchBuffer(int capacity, long highestPossibleNodeCount, Optional<LongSet> nodeLabelIds, Optional<Boolean> hasLabelInformation, Optional<Boolean> readProperty) {
        super(capacity);
        this.highestPossibleNodeCount = highestPossibleNodeCount;
        this.nodeLabelIds = nodeLabelIds.orElseGet(LongHashSet::new);
        this.hasLabelInformation = hasLabelInformation.orElse(false);
        this.properties = readProperty.orElse(false) != false ? new PropertyReference[capacity] : null;
        this.labelIds = new long[capacity][];
        this.skipOrphans = GdsFeatureToggles.SKIP_ORPHANS.isEnabled();
    }

    @Override
    public void offer(NodeReference record) {
        if (this.skipOrphans && record.relationshipReference() == -1L) {
            return;
        }
        if (record.nodeId() >= this.highestPossibleNodeCount) {
            return;
        }
        if (this.nodeLabelIds.isEmpty()) {
            PropertyReference propertiesReference = this.properties == null ? Neo4jProxy.noPropertyReference() : record.propertiesReference();
            this.add(record.nodeId(), propertiesReference, ANY_LABEL_LABELS);
        } else {
            boolean atLeastOneLabelFound = false;
            long[] labels = record.labels();
            for (int i = 0; i < labels.length; ++i) {
                long l = labels[i];
                if (!this.nodeLabelIds.contains(l) && !this.nodeLabelIds.contains(-1L)) {
                    labels[i] = -4L;
                    continue;
                }
                atLeastOneLabelFound = true;
            }
            if (atLeastOneLabelFound) {
                PropertyReference propertiesReference = this.properties == null ? Neo4jProxy.noPropertyReference() : record.propertiesReference();
                this.add(record.nodeId(), propertiesReference, labels);
            }
        }
    }

    public void add(long nodeId, PropertyReference propertyReference, long[] labels) {
        if (nodeId >= this.highestPossibleNodeCount) {
            return;
        }
        int len = this.length++;
        this.buffer[len] = nodeId;
        if (this.properties != null) {
            this.properties[len] = propertyReference;
        }
        if (this.labelIds != null) {
            this.labelIds[len] = labels;
        }
    }

    public PropertyReference[] properties() {
        return this.properties;
    }

    public boolean hasLabelInformation() {
        return this.hasLabelInformation;
    }

    public long[][] labelIds() {
        return this.labelIds;
    }
}

