/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.loading;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.neo4j.gds.core.loading.ValueConverter;
import org.neo4j.gds.core.loading.construction.NodeLabelTokens;
import org.neo4j.gds.core.loading.construction.NodesBuilder;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.utils.StringFormatting;
import org.neo4j.graphdb.QueryStatistics;
import org.neo4j.kernel.impl.query.QueryExecutionKernelException;
import org.neo4j.kernel.impl.query.QuerySubscriber;
import org.neo4j.values.AnyValue;
import org.neo4j.values.SequenceValue;
import org.neo4j.values.storable.NumberValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.VirtualValues;

class NodeSubscriber
implements QuerySubscriber {
    private static final String ID_COLUMN = "id";
    private static final int UNINITIALIZED = -1;
    static final String LABELS_COLUMN = "labels";
    static final Set<String> RESERVED_COLUMNS = Set.of("id", "labels");
    static final Set<String> REQUIRED_COLUMNS = Set.of("id");
    private final ProgressTracker progressTracker;
    private long rows;
    private long maxNeoId = 0L;
    private NodesBuilder nodesBuilder;
    private long neoId = -1L;
    private SequenceValue labels = VirtualValues.EMPTY_LIST;
    private Map<String, Value> properties;
    private int idOffset = -1;
    private int labelOffset = -1;
    private String[] fieldNames;
    private Optional<RuntimeException> error = Optional.empty();

    public NodeSubscriber(ProgressTracker progressTracker) {
        this.progressTracker = progressTracker;
    }

    void initialize(String[] fieldNames, NodesBuilder nodesBuilder) {
        this.fieldNames = fieldNames;
        this.nodesBuilder = nodesBuilder;
        for (int i = 0; i < fieldNames.length; ++i) {
            if (fieldNames[i].equals(ID_COLUMN)) {
                this.idOffset = i;
            }
            if (!fieldNames[i].equals(LABELS_COLUMN)) continue;
            this.labelOffset = i;
        }
    }

    Optional<RuntimeException> error() {
        return this.error;
    }

    long rows() {
        return this.rows;
    }

    long maxId() {
        return this.maxNeoId;
    }

    public void onResult(int numberOfFields) {
    }

    public void onRecord() {
        this.properties = new HashMap<String, Value>();
    }

    public void onField(int offset, AnyValue value) {
        if (offset == this.idOffset) {
            this.neoId = ((NumberValue)value).longValue();
            if (this.neoId > this.maxNeoId) {
                this.maxNeoId = this.neoId;
            }
        } else if (offset == this.labelOffset) {
            if (!value.isSequenceValue()) {
                throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Type of column `%s` should be of type List, but was `%s`", (Object[])new Object[]{LABELS_COLUMN, value}));
            }
            this.labels = (SequenceValue)value;
        } else if (value != Values.NO_VALUE) {
            this.properties.put(this.fieldNames[offset], ValueConverter.toValue(value));
        }
    }

    public void onRecordCompleted() {
        if (this.labelOffset >= 0 && this.labels.isEmpty()) {
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Node(%d) does not specify a label, but label column '%s' was specified.", (Object[])new Object[]{this.neoId, LABELS_COLUMN}));
        }
        if (this.labels.isEmpty()) {
            this.nodesBuilder.addNode(this.neoId, this.properties);
        } else {
            this.nodesBuilder.addNode(this.neoId, this.properties, NodeLabelTokens.of(this.labels));
        }
        ++this.rows;
        this.progressTracker.logProgress();
    }

    public void onError(Throwable throwable) {
        this.error = throwable instanceof RuntimeException ? Optional.of((RuntimeException)throwable) : (throwable instanceof QueryExecutionKernelException ? Optional.of(((QueryExecutionKernelException)throwable).asUserException()) : Optional.of(new RuntimeException(throwable)));
    }

    public void onResultCompleted(QueryStatistics statistics) {
    }
}

