/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.loading;

import java.util.Arrays;
import org.neo4j.gds.compat.Neo4jProxy;
import org.neo4j.gds.core.loading.MultipleNodeLabelIndexBasedScanner;
import org.neo4j.gds.core.loading.NodeCursorBasedScanner;
import org.neo4j.gds.core.loading.NodeLabelIndexBasedScanner;
import org.neo4j.gds.core.loading.NodeReference;
import org.neo4j.gds.core.loading.StoreScanner;
import org.neo4j.gds.transaction.TransactionContext;
import org.neo4j.gds.utils.GdsFeatureToggles;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.logging.Log;

public final class NodeScannerFactory {
    private NodeScannerFactory() {
    }

    public static StoreScanner.Factory<NodeReference> create(TransactionContext transactionContext, int[] labelIds, Log log) {
        boolean hasNodeLabelIndex = NodeScannerFactory.hasNodeLabelIndex(transactionContext);
        if (!hasNodeLabelIndex && labelIds.length > 0) {
            log.info("Attempted to use node label index, but no index was found. Falling back to node store scan.");
        }
        if (Arrays.stream(labelIds).anyMatch(labelId -> labelId == -1) || !hasNodeLabelIndex) {
            return NodeCursorBasedScanner::new;
        }
        if (labelIds.length == 1) {
            return (prefetchSize, transaction) -> new NodeLabelIndexBasedScanner(labelIds[0], prefetchSize, transaction, GdsFeatureToggles.USE_PARTITIONED_SCAN.isEnabled());
        }
        return (prefetchSize, transaction) -> new MultipleNodeLabelIndexBasedScanner(labelIds, prefetchSize, transaction, GdsFeatureToggles.USE_PARTITIONED_SCAN.isEnabled());
    }

    private static boolean hasNodeLabelIndex(TransactionContext transactionContext) {
        return (Boolean)transactionContext.apply((tx, ktx) -> Neo4jProxy.hasNodeLabelIndex((KernelTransaction)ktx));
    }
}

