/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.loading;

import org.neo4j.gds.compat.Neo4jProxy;
import org.neo4j.gds.compat.PropertyReference;
import org.neo4j.gds.core.loading.NodeReference;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.NodeLabelIndexCursor;
import org.neo4j.internal.kernel.api.Read;

public class NodeLabelIndexReference
implements NodeReference {
    private final NodeLabelIndexCursor labelIndexCursor;
    private final Read dataRead;
    private final NodeCursor nodeCursor;
    private final long[] labelIds;

    NodeLabelIndexReference(NodeLabelIndexCursor labelIndexCursor, Read dataRead, NodeCursor nodeCursor, int labelId) {
        this.labelIndexCursor = labelIndexCursor;
        this.dataRead = dataRead;
        this.nodeCursor = nodeCursor;
        this.labelIds = new long[]{labelId};
    }

    @Override
    public long nodeId() {
        return this.labelIndexCursor.nodeReference();
    }

    @Override
    public long[] labels() {
        return this.labelIds;
    }

    @Override
    public long relationshipReference() {
        this.dataRead.singleNode(this.labelIndexCursor.nodeReference(), this.nodeCursor);
        if (this.nodeCursor.next()) {
            return this.nodeCursor.relationshipsReference();
        }
        return -1L;
    }

    @Override
    public PropertyReference propertiesReference() {
        this.dataRead.singleNode(this.labelIndexCursor.nodeReference(), this.nodeCursor);
        if (this.nodeCursor.next()) {
            return Neo4jProxy.propertyReference((NodeCursor)this.nodeCursor);
        }
        return Neo4jProxy.noPropertyReference();
    }

    void close() {
        this.nodeCursor.close();
    }
}

