/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.loading;

import org.neo4j.gds.compat.Neo4jProxy;
import org.neo4j.gds.compat.StoreScan;
import org.neo4j.gds.core.loading.AbstractNodeCursorBasedScanner;
import org.neo4j.gds.core.loading.NodeLabelIndexReference;
import org.neo4j.gds.core.loading.NodeReference;
import org.neo4j.gds.transaction.TransactionContext;
import org.neo4j.internal.kernel.api.NodeLabelIndexCursor;
import org.neo4j.kernel.api.KernelTransaction;

final class NodeLabelIndexBasedScanner
extends AbstractNodeCursorBasedScanner<NodeLabelIndexCursor> {
    private final int labelId;
    private final boolean allowPartitionedScan;

    NodeLabelIndexBasedScanner(int labelId, int prefetchSize, TransactionContext transaction, boolean allowPartitionedScan) {
        super(prefetchSize, transaction);
        this.labelId = labelId;
        this.allowPartitionedScan = allowPartitionedScan;
    }

    @Override
    NodeLabelIndexCursor entityCursor(KernelTransaction transaction) {
        return Neo4jProxy.allocateNodeLabelIndexCursor((KernelTransaction)transaction);
    }

    @Override
    StoreScan<NodeLabelIndexCursor> entityCursorScan(KernelTransaction transaction) {
        return Neo4jProxy.nodeLabelIndexScan((KernelTransaction)transaction, (int)this.labelId, (int)this.batchSize(), (boolean)this.allowPartitionedScan);
    }

    @Override
    NodeReference cursorReference(KernelTransaction transaction, NodeLabelIndexCursor cursor) {
        return new NodeLabelIndexReference(cursor, transaction.dataRead(), Neo4jProxy.allocateNodeCursor((KernelTransaction)transaction), this.labelId);
    }

    @Override
    void closeCursorReference(NodeReference nodeReference) {
        ((NodeLabelIndexReference)nodeReference).close();
    }
}

