/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.loading;

import com.carrotsearch.hppc.IntObjectMap;
import java.util.Collections;
import java.util.List;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.compat.PropertyReference;
import org.neo4j.gds.core.loading.IdMapAllocator;
import org.neo4j.gds.core.loading.IdMapBuilder;
import org.neo4j.gds.core.loading.LabelInformation;
import org.neo4j.gds.core.loading.NodesBatchBuffer;
import org.neo4j.gds.core.utils.RawValues;

public class NodeImporter {
    private final IdMapBuilder idMapBuilder;
    private final LabelInformation.Builder labelInformationBuilder;
    private final IntObjectMap<List<NodeLabel>> labelTokenNodeLabelMapping;
    private final boolean importProperties;

    public NodeImporter(IdMapBuilder idMapBuilder, LabelInformation.Builder labelInformationBuilder, IntObjectMap<List<NodeLabel>> labelTokenNodeLabelMapping, boolean importProperties) {
        this.idMapBuilder = idMapBuilder;
        this.labelInformationBuilder = labelInformationBuilder;
        this.labelTokenNodeLabelMapping = labelTokenNodeLabelMapping;
        this.importProperties = importProperties;
    }

    public long importNodes(NodesBatchBuffer buffer, PropertyReader reader) {
        int batchLength = buffer.length();
        if (batchLength == 0) {
            return 0L;
        }
        IdMapAllocator idMapAllocator = this.idMapBuilder.allocate(batchLength);
        if ((batchLength = idMapAllocator.allocatedSize()) == 0) {
            return 0L;
        }
        long[] batch = buffer.batch();
        PropertyReference[] properties = buffer.properties();
        long[][] labelIds = buffer.labelIds();
        idMapAllocator.insert(batch);
        if (buffer.hasLabelInformation()) {
            this.setNodeLabelInformation(batch, batchLength, idMapAllocator.startId(), labelIds, (nodeIds, startIndex, pos) -> nodeIds[pos]);
        }
        int importedProperties = this.importProperties ? NodeImporter.importProperties(reader, batch, properties, labelIds, batchLength) : 0;
        return RawValues.combineIntInt(batchLength, importedProperties);
    }

    private void setNodeLabelInformation(long[] batch, int batchLength, long startIndex, long[][] labelIds, IdFunction idFunction) {
        int cappedBatchLength = Math.min(labelIds.length, batchLength);
        for (int i = 0; i < cappedBatchLength; ++i) {
            long[] labelIdsForNode;
            long nodeId = idFunction.apply(batch, startIndex, i);
            for (long labelId : labelIdsForNode = labelIds[i]) {
                List elementIdentifiers = (List)this.labelTokenNodeLabelMapping.getOrDefault((int)labelId, Collections.emptyList());
                for (NodeLabel elementIdentifier : elementIdentifiers) {
                    this.labelInformationBuilder.addNodeIdToLabel(elementIdentifier, nodeId);
                }
            }
        }
    }

    private static int importProperties(PropertyReader reader, long[] batch, PropertyReference[] properties, long[][] labelIds, int length) {
        int batchImportedProperties = 0;
        for (int i = 0; i < length; ++i) {
            batchImportedProperties += reader.readProperty(batch[i], labelIds[i], properties[i]);
        }
        return batchImportedProperties;
    }

    @FunctionalInterface
    static interface IdFunction {
        public long apply(long[] var1, long var2, int var4);
    }

    public static interface PropertyReader {
        public int readProperty(long var1, long[] var3, PropertyReference var4);
    }
}

