/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.loading;

import com.carrotsearch.hppc.IntObjectHashMap;
import com.carrotsearch.hppc.IntObjectMap;
import com.carrotsearch.hppc.LongObjectHashMap;
import com.carrotsearch.hppc.LongObjectMap;
import com.carrotsearch.hppc.cursors.IntObjectCursor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.PropertyMapping;
import org.neo4j.gds.PropertyMappings;
import org.neo4j.gds.api.IdMap;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.compat.Neo4jProxy;
import org.neo4j.gds.compat.PropertyReference;
import org.neo4j.gds.core.GraphDimensions;
import org.neo4j.gds.core.loading.nodeproperties.NodePropertiesFromStoreBuilder;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.values.storable.Value;

public final class NativeNodePropertyImporter {
    private final BuildersByLabel buildersByLabel;
    private final BuildersByLabelIdAndPropertyId buildersByLabelIdAndPropertyId;
    private final boolean containsAnyLabelProjection;

    public static Builder builder() {
        return new Builder();
    }

    private NativeNodePropertyImporter(BuildersByLabel buildersByLabel, BuildersByLabelIdAndPropertyId buildersByLabelIdAndPropertyId) {
        this.buildersByLabel = buildersByLabel;
        this.buildersByLabelIdAndPropertyId = buildersByLabelIdAndPropertyId;
        this.containsAnyLabelProjection = buildersByLabelIdAndPropertyId.containsAnyLabelProjection();
    }

    int importProperties(long neoNodeId, long[] labelIds, PropertyReference propertiesReference, KernelTransaction kernelTransaction) {
        try (PropertyCursor pc = Neo4jProxy.allocatePropertyCursor((KernelTransaction)kernelTransaction);){
            Neo4jProxy.nodeProperties((KernelTransaction)kernelTransaction, (long)neoNodeId, (PropertyReference)propertiesReference, (PropertyCursor)pc);
            int nodePropertiesRead = 0;
            while (pc.next()) {
                nodePropertiesRead += this.importProperty(neoNodeId, labelIds, pc);
            }
            int n = nodePropertiesRead;
            return n;
        }
    }

    public Map<PropertyMapping, NodePropertyValues> result(IdMap idMap) {
        return this.buildersByLabel.build(idMap);
    }

    private int importProperty(long neoNodeId, long[] labelIds, PropertyCursor propertyCursor) {
        int propertiesImported = 0;
        int propertyKey = propertyCursor.propertyKey();
        for (long labelId : labelIds) {
            BuildersByPropertyId buildersByPropertyId;
            if (labelId == -4L || labelId == -1L || (buildersByPropertyId = this.buildersByLabelIdAndPropertyId.get(labelId)) == null) continue;
            propertiesImported += this.setPropertyValue(neoNodeId, propertyCursor, propertyKey, buildersByPropertyId);
        }
        if (this.containsAnyLabelProjection) {
            propertiesImported += this.setPropertyValue(neoNodeId, propertyCursor, propertyKey, this.buildersByLabelIdAndPropertyId.get(-1L));
        }
        return propertiesImported;
    }

    private int setPropertyValue(long neoNodeId, PropertyCursor propertyCursor, int propertyId, BuildersByPropertyId buildersByPropertyId) {
        int propertiesImported = 0;
        List<NodePropertiesFromStoreBuilder> builders = buildersByPropertyId.get(propertyId);
        if (builders != null) {
            Value value = propertyCursor.propertyValue();
            for (NodePropertiesFromStoreBuilder builder : builders) {
                builder.set(neoNodeId, value);
                ++propertiesImported;
            }
        }
        return propertiesImported;
    }

    static final class LabelIdByLabel {
        private final Map<NodeLabel, Integer> labelIdByLabel = new HashMap<NodeLabel, Integer>();

        static LabelIdByLabel create(IntObjectMap<List<NodeLabel>> mapping) {
            LabelIdByLabel instance = new LabelIdByLabel();
            for (IntObjectCursor cursor : mapping) {
                for (NodeLabel label : (List)cursor.value) {
                    instance.labelIdByLabel.put(label, cursor.key);
                }
            }
            return instance;
        }

        int get(NodeLabel label) {
            return this.labelIdByLabel.get(label);
        }

        private LabelIdByLabel() {
        }
    }

    static final class BuildersByPropertyId {
        private final IntObjectMap<List<NodePropertiesFromStoreBuilder>> builders = new IntObjectHashMap();

        List<NodePropertiesFromStoreBuilder> get(int propertyId) {
            return (List)this.builders.get(propertyId);
        }

        void add(int propertyId, NodePropertiesFromStoreBuilder builder) {
            if (!this.builders.containsKey(propertyId)) {
                this.builders.put(propertyId, new ArrayList());
            }
            ((List)this.builders.get(propertyId)).add(builder);
        }

        private BuildersByPropertyId() {
        }
    }

    static final class BuildersByLabelIdAndPropertyId {
        private final LongObjectMap<BuildersByPropertyId> builders = new LongObjectHashMap();

        static BuildersByLabelIdAndPropertyId create(BuildersByLabel buildersByLabel, IntObjectMap<List<NodeLabel>> labelsByLabelId, Map<String, Integer> propertyIds) {
            LabelIdByLabel labelIdByLabel = LabelIdByLabel.create(labelsByLabelId);
            BuildersByLabelIdAndPropertyId instance = new BuildersByLabelIdAndPropertyId();
            buildersByLabel.forEach((labelIdentifier, builders) -> {
                int labelId = labelIdByLabel.get((NodeLabel)labelIdentifier);
                builders.forEach((propertyMapping, builder) -> {
                    int propertyId = (Integer)propertyIds.get(propertyMapping.neoPropertyKey());
                    instance.put(labelId, propertyId, (NodePropertiesFromStoreBuilder)builder);
                });
            });
            return instance;
        }

        boolean containsAnyLabelProjection() {
            return this.builders.containsKey(-1L);
        }

        BuildersByPropertyId get(long labelId) {
            return (BuildersByPropertyId)this.builders.get(labelId);
        }

        void put(int labelId, int propertyId, NodePropertiesFromStoreBuilder builder) {
            if (!this.builders.containsKey((long)labelId)) {
                this.builders.put((long)labelId, (Object)new BuildersByPropertyId());
            }
            ((BuildersByPropertyId)this.builders.get((long)labelId)).add(propertyId, builder);
        }

        private BuildersByLabelIdAndPropertyId() {
        }
    }

    static final class BuildersByLabel {
        private final Map<String, NodePropertiesFromStoreBuilder> buildersByPropertyKey;
        private final Map<String, PropertyMapping> propertyMappings;
        private final Map<NodeLabel, Map<PropertyMapping, NodePropertiesFromStoreBuilder>> buildersByLabel = new HashMap<NodeLabel, Map<PropertyMapping, NodePropertiesFromStoreBuilder>>();

        static BuildersByLabel create(Map<NodeLabel, PropertyMappings> propertyMappingsByLabel, int concurrency) {
            HashMap propertyBuildersByKey = new HashMap();
            propertyMappingsByLabel.values().stream().flatMap(propertyMappings -> propertyMappings.mappings().stream()).forEach((? super T propertyMapping) -> propertyBuildersByKey.putIfAbsent(propertyMapping.propertyKey(), NodePropertiesFromStoreBuilder.of(propertyMapping.defaultValue(), concurrency)));
            BuildersByLabel instance = new BuildersByLabel();
            for (Map.Entry<NodeLabel, PropertyMappings> entry : propertyMappingsByLabel.entrySet()) {
                NodeLabel label = entry.getKey();
                for (PropertyMapping propertyMapping2 : entry.getValue()) {
                    instance.put(label, propertyMapping2, (NodePropertiesFromStoreBuilder)propertyBuildersByKey.get(propertyMapping2.propertyKey()));
                }
            }
            return instance;
        }

        private BuildersByLabel() {
            this.propertyMappings = new HashMap<String, PropertyMapping>();
            this.buildersByPropertyKey = new HashMap<String, NodePropertiesFromStoreBuilder>();
        }

        private void put(NodeLabel label, PropertyMapping propertyMapping, NodePropertiesFromStoreBuilder builder) {
            this.propertyMappings.put(propertyMapping.propertyKey(), propertyMapping);
            this.buildersByPropertyKey.put(propertyMapping.propertyKey(), builder);
            this.buildersByLabel.computeIfAbsent(label, __ -> new HashMap()).computeIfAbsent(propertyMapping, __ -> builder);
        }

        void forEach(BiConsumer<NodeLabel, Map<PropertyMapping, NodePropertiesFromStoreBuilder>> action) {
            this.buildersByLabel.forEach(action);
        }

        Map<PropertyMapping, NodePropertyValues> build(IdMap idMap) {
            return this.buildersByPropertyKey.entrySet().stream().collect(Collectors.toMap(entry -> this.propertyMappings.get(entry.getKey()), entry -> ((NodePropertiesFromStoreBuilder)entry.getValue()).build(idMap)));
        }
    }

    public static final class Builder {
        private int concurrency = 4;
        private Map<NodeLabel, PropertyMappings> propertyMappings;
        private GraphDimensions dimensions;

        private Builder() {
        }

        public Builder concurrency(int concurrency) {
            this.concurrency = concurrency;
            return this;
        }

        public Builder propertyMappings(Map<NodeLabel, PropertyMappings> propertyMappingsByLabel) {
            this.propertyMappings = propertyMappingsByLabel;
            return this;
        }

        public Builder dimensions(GraphDimensions dimensions) {
            this.dimensions = dimensions;
            return this;
        }

        public NativeNodePropertyImporter build() {
            BuildersByLabel nodePropertyBuilders = BuildersByLabel.create(this.propertyMappings, this.concurrency);
            BuildersByLabelIdAndPropertyId buildersByLabelIdAndPropertyId = BuildersByLabelIdAndPropertyId.create(nodePropertyBuilders, (IntObjectMap<List<NodeLabel>>)this.dimensions.tokenNodeLabelMapping(), this.dimensions.nodePropertyTokens());
            return new NativeNodePropertyImporter(nodePropertyBuilders, buildersByLabelIdAndPropertyId);
        }
    }
}

