/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.loading;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.neo4j.gds.NodeProjection;
import org.neo4j.gds.NodeProjections;
import org.neo4j.gds.Orientation;
import org.neo4j.gds.RelationshipProjection;
import org.neo4j.gds.RelationshipProjections;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.api.CSRGraphStoreFactory;
import org.neo4j.gds.api.GraphLoaderContext;
import org.neo4j.gds.api.IdMap;
import org.neo4j.gds.api.schema.GraphSchema;
import org.neo4j.gds.compat.GraphDatabaseApiProxy;
import org.neo4j.gds.config.GraphProjectFromStoreConfig;
import org.neo4j.gds.core.GraphDimensions;
import org.neo4j.gds.core.GraphDimensionsStoreReader;
import org.neo4j.gds.core.GraphDimensionsValidation;
import org.neo4j.gds.core.IdMapBehaviorServiceProvider;
import org.neo4j.gds.core.compress.AdjacencyListBehavior;
import org.neo4j.gds.core.huge.HugeGraph;
import org.neo4j.gds.core.loading.AdjacencyBuffer;
import org.neo4j.gds.core.loading.CSRGraphStore;
import org.neo4j.gds.core.loading.CSRGraphStoreUtil;
import org.neo4j.gds.core.loading.IdMapAndProperties;
import org.neo4j.gds.core.loading.ImmutableStaticCapabilities;
import org.neo4j.gds.core.loading.IndexPropertyMappings;
import org.neo4j.gds.core.loading.RelationshipsAndProperties;
import org.neo4j.gds.core.loading.ScanningNodesImporter;
import org.neo4j.gds.core.loading.ScanningNodesImporterBuilder;
import org.neo4j.gds.core.loading.ScanningRelationshipsImporter;
import org.neo4j.gds.core.loading.ScanningRelationshipsImporterBuilder;
import org.neo4j.gds.core.loading.nodeproperties.NodePropertiesFromStoreBuilder;
import org.neo4j.gds.core.utils.mem.MemoryEstimation;
import org.neo4j.gds.core.utils.mem.MemoryEstimations;
import org.neo4j.gds.core.utils.paged.HugeIntArray;
import org.neo4j.gds.core.utils.paged.HugeLongArray;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.core.utils.progress.tasks.Task;
import org.neo4j.gds.core.utils.progress.tasks.TaskProgressTracker;
import org.neo4j.gds.core.utils.progress.tasks.Tasks;
import org.neo4j.gds.core.utils.warnings.EmptyUserLogRegistryFactory;
import org.neo4j.gds.utils.StringFormatting;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.internal.id.IdGeneratorFactory;

public final class NativeFactory
extends CSRGraphStoreFactory<GraphProjectFromStoreConfig> {
    private final GraphProjectFromStoreConfig storeConfig;

    public NativeFactory(GraphProjectFromStoreConfig graphProjectConfig, GraphLoaderContext loadingContext) {
        this(graphProjectConfig, loadingContext, (GraphDimensions)new GraphDimensionsStoreReader(loadingContext.transactionContext(), graphProjectConfig, (IdGeneratorFactory)GraphDatabaseApiProxy.resolveDependency((GraphDatabaseService)loadingContext.graphDatabaseService(), IdGeneratorFactory.class)).call());
    }

    public NativeFactory(GraphProjectFromStoreConfig graphProjectConfig, GraphLoaderContext loadingContext, GraphDimensions graphDimensions) {
        super(graphProjectConfig, ImmutableStaticCapabilities.of(true), loadingContext, graphDimensions);
        this.storeConfig = graphProjectConfig;
    }

    @Override
    public MemoryEstimation estimateMemoryUsageDuringLoading() {
        return NativeFactory.getMemoryEstimation(this.storeConfig.nodeProjections(), this.storeConfig.relationshipProjections(), true);
    }

    @Override
    public MemoryEstimation estimateMemoryUsageAfterLoading() {
        return NativeFactory.getMemoryEstimation(this.storeConfig.nodeProjections(), this.storeConfig.relationshipProjections(), false);
    }

    public static MemoryEstimation getMemoryEstimation(NodeProjections nodeProjections, RelationshipProjections relationshipProjections, boolean isLoading) {
        MemoryEstimations.Builder builder = MemoryEstimations.builder((String)"graph projection");
        builder.add("nodeIdMap", IdMapBehaviorServiceProvider.idMapBehavior().memoryEstimation());
        nodeProjections.allProperties().forEach(property -> builder.add(property, NodePropertiesFromStoreBuilder.memoryEstimation()));
        relationshipProjections.projections().forEach((relationshipType, relationshipProjection) -> {
            boolean undirected;
            boolean bl = undirected = relationshipProjection.orientation() == Orientation.UNDIRECTED;
            if (isLoading) {
                builder.max(List.of(NativeFactory.relationshipEstimationDuringLoading(relationshipType, relationshipProjection, undirected), NativeFactory.relationshipEstimationAfterLoading(relationshipType, relationshipProjection, undirected)));
            } else {
                builder.add(MemoryEstimations.builder(HugeGraph.class).build());
                builder.add(NativeFactory.relationshipEstimationAfterLoading(relationshipType, relationshipProjection, undirected));
            }
        });
        return builder.build();
    }

    @NotNull
    private static MemoryEstimation relationshipEstimationDuringLoading(RelationshipType relationshipType, RelationshipProjection relationshipProjection, boolean undirected) {
        MemoryEstimations.Builder duringLoadingEstimation = MemoryEstimations.builder((String)"size during loading");
        duringLoadingEstimation.add(StringFormatting.formatWithLocale((String)"adjacency loading buffer for '%s'", (Object[])new Object[]{relationshipType}), AdjacencyBuffer.memoryEstimation(relationshipType, (int)relationshipProjection.properties().stream().count(), undirected));
        duringLoadingEstimation.perNode(StringFormatting.formatWithLocale((String)"offsets for '%s'", (Object[])new Object[]{relationshipType}), HugeLongArray::memoryEstimation);
        duringLoadingEstimation.perNode(StringFormatting.formatWithLocale((String)"degrees for '%s'", (Object[])new Object[]{relationshipType}), HugeIntArray::memoryEstimation);
        relationshipProjection.properties().mappings().forEach(resolvedPropertyMapping -> duringLoadingEstimation.perNode(StringFormatting.formatWithLocale((String)"property '%s.%s'", (Object[])new Object[]{relationshipType, resolvedPropertyMapping.propertyKey()}), HugeLongArray::memoryEstimation));
        return duringLoadingEstimation.build();
    }

    private static MemoryEstimation relationshipEstimationAfterLoading(RelationshipType relationshipType, RelationshipProjection relationshipProjection, boolean undirected) {
        MemoryEstimations.Builder afterLoadingEstimation = MemoryEstimations.builder((String)"size after loading");
        afterLoadingEstimation.add(StringFormatting.formatWithLocale((String)"adjacency list for '%s'", (Object[])new Object[]{relationshipType}), AdjacencyListBehavior.adjacencyListEstimation(relationshipType, undirected));
        relationshipProjection.properties().mappings().forEach(resolvedPropertyMapping -> afterLoadingEstimation.add(StringFormatting.formatWithLocale((String)"property '%s.%s", (Object[])new Object[]{relationshipType, resolvedPropertyMapping.propertyKey()}), AdjacencyListBehavior.adjacencyPropertiesEstimation(relationshipType, undirected)));
        return afterLoadingEstimation.build();
    }

    @Override
    protected ProgressTracker initProgressTracker() {
        long relationshipCount = ((GraphProjectFromStoreConfig)this.graphProjectConfig).relationshipProjections().projections().entrySet().stream().map(entry -> {
            long relCount = ((RelationshipType)entry.getKey()).name.equals("*") ? this.dimensions.relationshipCounts().values().stream().reduce(Long::sum).orElse(0L) : this.dimensions.relationshipCounts().getOrDefault(entry.getKey(), 0L);
            return ((RelationshipProjection)entry.getValue()).orientation() == Orientation.UNDIRECTED ? relCount * 2L : relCount;
        }).mapToLong(Long::longValue).sum();
        IndexPropertyMappings.LoadablePropertyMappings properties = IndexPropertyMappings.prepareProperties((GraphProjectFromStoreConfig)this.graphProjectConfig, this.dimensions, this.loadingContext.transactionContext());
        List<Task> nodeTasks = properties.indexedProperties().isEmpty() ? List.of(Tasks.leaf("Store Scan", this.dimensions.nodeCount())) : List.of(Tasks.leaf("Store Scan", this.dimensions.nodeCount()), Tasks.leaf("Property Index Scan", (long)properties.indexedProperties().size() * this.dimensions.nodeCount()));
        Task task = Tasks.task("Loading", Tasks.task("Nodes", nodeTasks), Tasks.task("Relationships", Tasks.leaf("Store Scan", relationshipCount), new Task[0]));
        return new TaskProgressTracker(task, this.loadingContext.log(), ((GraphProjectFromStoreConfig)this.graphProjectConfig).readConcurrency(), ((GraphProjectFromStoreConfig)this.graphProjectConfig).jobId(), this.loadingContext.taskRegistryFactory(), EmptyUserLogRegistryFactory.INSTANCE);
    }

    @Override
    protected GraphSchema computeGraphSchema(IdMapAndProperties idMapAndProperties, RelationshipsAndProperties relationshipsAndProperties) {
        return CSRGraphStoreUtil.computeGraphSchema(idMapAndProperties, label -> ((NodeProjection)this.storeConfig.nodeProjections().projections().get(label)).properties().propertyKeys(), relationshipsAndProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CSRGraphStore build() {
        GraphDimensionsValidation.validate(this.dimensions, this.storeConfig);
        int concurrency = ((GraphProjectFromStoreConfig)this.graphProjectConfig).readConcurrency();
        try {
            this.progressTracker.beginSubTask();
            IdMapAndProperties nodes = this.loadNodes(concurrency);
            RelationshipsAndProperties relationships = this.loadRelationships(nodes.idMap(), concurrency);
            CSRGraphStore graphStore = this.createGraphStore(nodes, relationships);
            this.logLoadingSummary(graphStore);
            CSRGraphStore cSRGraphStore = graphStore;
            return cSRGraphStore;
        }
        finally {
            this.progressTracker.endSubTask();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IdMapAndProperties loadNodes(int concurrency) {
        ScanningNodesImporter scanningNodesImporter = new ScanningNodesImporterBuilder().concurrency(concurrency).graphProjectConfig((GraphProjectFromStoreConfig)this.graphProjectConfig).dimensions(this.dimensions).loadingContext(this.loadingContext).progressTracker(this.progressTracker).build();
        try {
            this.progressTracker.beginSubTask();
            IdMapAndProperties idMapAndProperties = (IdMapAndProperties)scanningNodesImporter.call();
            return idMapAndProperties;
        }
        finally {
            this.progressTracker.endSubTask();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RelationshipsAndProperties loadRelationships(IdMap idMap, int concurrency) {
        ScanningRelationshipsImporter scanningRelationshipsImporter = new ScanningRelationshipsImporterBuilder().idMap(idMap).graphProjectConfig((GraphProjectFromStoreConfig)this.graphProjectConfig).loadingContext(this.loadingContext).dimensions(this.dimensions).progressTracker(this.progressTracker).concurrency(concurrency).build();
        try {
            this.progressTracker.beginSubTask();
            RelationshipsAndProperties relationshipsAndProperties = (RelationshipsAndProperties)scanningRelationshipsImporter.call();
            return relationshipsAndProperties;
        }
        finally {
            this.progressTracker.endSubTask();
        }
    }
}

