/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.loading;

import org.neo4j.gds.compat.CompositeNodeCursor;
import org.neo4j.gds.compat.Neo4jProxy;
import org.neo4j.gds.compat.PropertyReference;
import org.neo4j.gds.core.loading.NodeReference;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.Read;

public class MultipleNodeLabelIndexReference
implements NodeReference {
    private final CompositeNodeCursor compositeNodeCursor;
    private final Read dataRead;
    private final NodeCursor nodeCursor;

    MultipleNodeLabelIndexReference(CompositeNodeCursor compositeNodeCursor, Read dataRead, NodeCursor nodeCursor) {
        this.compositeNodeCursor = compositeNodeCursor;
        this.dataRead = dataRead;
        this.nodeCursor = nodeCursor;
    }

    @Override
    public long nodeId() {
        return this.compositeNodeCursor.nodeReference();
    }

    @Override
    public long[] labels() {
        return this.compositeNodeCursor.currentLabels();
    }

    @Override
    public long relationshipReference() {
        this.dataRead.singleNode(this.compositeNodeCursor.nodeReference(), this.nodeCursor);
        if (this.nodeCursor.next()) {
            return this.nodeCursor.relationshipsReference();
        }
        return -1L;
    }

    @Override
    public PropertyReference propertiesReference() {
        this.dataRead.singleNode(this.compositeNodeCursor.nodeReference(), this.nodeCursor);
        if (this.nodeCursor.next()) {
            return Neo4jProxy.propertyReference((NodeCursor)this.nodeCursor);
        }
        return Neo4jProxy.noPropertyReference();
    }

    void close() {
        this.nodeCursor.close();
    }
}

