/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.loading;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.neo4j.gds.compat.CompositeNodeCursor;
import org.neo4j.gds.compat.Neo4jProxy;
import org.neo4j.gds.compat.StoreScan;
import org.neo4j.gds.core.loading.AbstractNodeCursorBasedScanner;
import org.neo4j.gds.core.loading.CompositeNodeScan;
import org.neo4j.gds.core.loading.MultipleNodeLabelIndexReference;
import org.neo4j.gds.core.loading.NodeReference;
import org.neo4j.gds.transaction.TransactionContext;
import org.neo4j.kernel.api.KernelTransaction;

final class MultipleNodeLabelIndexBasedScanner
extends AbstractNodeCursorBasedScanner<CompositeNodeCursor> {
    private final int[] labelIds;
    private final boolean allowPartitionedScan;

    MultipleNodeLabelIndexBasedScanner(int[] labelIds, int prefetchSize, TransactionContext transaction, boolean allowPartitionedScan) {
        super(prefetchSize, transaction);
        this.labelIds = labelIds;
        this.allowPartitionedScan = allowPartitionedScan;
    }

    @Override
    CompositeNodeCursor entityCursor(KernelTransaction transaction) {
        List cursors = Arrays.stream(this.labelIds).mapToObj(i -> Neo4jProxy.allocateNodeLabelIndexCursor((KernelTransaction)transaction)).collect(Collectors.toList());
        return Neo4jProxy.compositeNodeCursor(cursors, (int[])this.labelIds);
    }

    @Override
    StoreScan<CompositeNodeCursor> entityCursorScan(KernelTransaction transaction) {
        return new CompositeNodeScan(Neo4jProxy.entityCursorScan((KernelTransaction)transaction, (int[])this.labelIds, (int)this.batchSize(), (boolean)this.allowPartitionedScan));
    }

    @Override
    NodeReference cursorReference(KernelTransaction transaction, CompositeNodeCursor cursor) {
        return new MultipleNodeLabelIndexReference(cursor, transaction.dataRead(), Neo4jProxy.allocateNodeCursor((KernelTransaction)transaction));
    }

    @Override
    void closeCursorReference(NodeReference nodeReference) {
        ((MultipleNodeLabelIndexReference)nodeReference).close();
    }
}

