/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.loading;

import com.carrotsearch.hppc.BitSet;
import com.carrotsearch.hppc.IntObjectMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.PrimitiveIterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.LongUnaryOperator;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.api.BatchNodeIterable;
import org.neo4j.gds.api.IdMap;
import org.neo4j.gds.core.loading.LabelInformation;
import org.neo4j.gds.core.loading.SingleLabelInformation;
import org.neo4j.gds.core.utils.paged.HugeAtomicGrowingBitSet;
import org.neo4j.gds.utils.StringFormatting;

public final class MultiLabelInformation
implements LabelInformation {
    private final Map<NodeLabel, BitSet> labelInformation;

    private MultiLabelInformation(Map<NodeLabel, BitSet> labelInformation) {
        this.labelInformation = labelInformation;
    }

    @Override
    public boolean isEmpty() {
        return this.labelInformation.isEmpty();
    }

    @Override
    public Set<NodeLabel> labelSet() {
        return this.labelInformation.keySet();
    }

    @Override
    public void forEach(LabelInformation.LabelInformationConsumer consumer) {
        for (Map.Entry<NodeLabel, BitSet> entry : this.labelInformation.entrySet()) {
            if (consumer.accept(entry.getKey(), entry.getValue())) continue;
            return;
        }
    }

    @Override
    public MultiLabelInformation filter(Collection<NodeLabel> nodeLabels) {
        return new MultiLabelInformation(nodeLabels.stream().collect(Collectors.toMap(nodeLabel -> nodeLabel, this.labelInformation::get)));
    }

    @Override
    public BitSet unionBitSet(Collection<NodeLabel> nodeLabels, long nodeCount) {
        assert (this.labelInformation.keySet().containsAll(nodeLabels));
        BitSet unionBitSet = new BitSet(nodeCount);
        nodeLabels.forEach((? super T label) -> unionBitSet.union(this.labelInformation.get(label)));
        return unionBitSet;
    }

    @Override
    public boolean hasLabel(long nodeId, NodeLabel nodeLabel) {
        if (nodeLabel.equals((Object)NodeLabel.ALL_NODES)) {
            return true;
        }
        BitSet bitSet = this.labelInformation.get(nodeLabel);
        return bitSet != null && bitSet.get(nodeId);
    }

    @Override
    public Set<NodeLabel> availableNodeLabels() {
        return this.labelSet();
    }

    @Override
    public List<NodeLabel> nodeLabelsForNodeId(long nodeId) {
        ArrayList<NodeLabel> labels = new ArrayList<NodeLabel>();
        this.forEach((nodeLabel, bitSet) -> {
            if (bitSet.get(nodeId)) {
                labels.add(nodeLabel);
            }
            return true;
        });
        return labels;
    }

    @Override
    public void forEachNodeLabel(long nodeId, IdMap.NodeLabelConsumer consumer) {
        this.forEach((nodeLabel, bitSet) -> {
            if (bitSet.get(nodeId)) {
                return consumer.accept(nodeLabel);
            }
            return true;
        });
    }

    @Override
    public void validateNodeLabelFilter(Collection<NodeLabel> nodeLabels) {
        List invalidLabels = nodeLabels.stream().filter((? super T label) -> !new HashSet<NodeLabel>(this.labelSet()).contains(label)).collect(Collectors.toList());
        if (!invalidLabels.isEmpty()) {
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Specified labels %s do not correspond to any of the node projections %s.", (Object[])new Object[]{invalidLabels, this.labelSet()}));
        }
    }

    @Override
    public PrimitiveIterator.OfLong nodeIterator(Collection<NodeLabel> labels, long nodeCount) {
        if (labels.contains(NodeLabel.ALL_NODES)) {
            return new BatchNodeIterable.IdIterator(nodeCount);
        }
        return new BatchNodeIterable.BitSetIdIterator(this.unionBitSet(labels, nodeCount));
    }

    public static final class Builder
    implements LabelInformation.Builder {
        private final long expectedCapacity;
        private final Map<NodeLabel, HugeAtomicGrowingBitSet> labelInformation;
        private final List<NodeLabel> starNodeLabelMappings;

        private Builder(long expectedCapacity, Map<NodeLabel, HugeAtomicGrowingBitSet> labelInformation, List<NodeLabel> starNodeLabelMappings) {
            this.expectedCapacity = expectedCapacity;
            this.labelInformation = labelInformation;
            this.starNodeLabelMappings = starNodeLabelMappings;
        }

        static Builder of(long expectedCapacity) {
            return new Builder(expectedCapacity, new ConcurrentHashMap<NodeLabel, HugeAtomicGrowingBitSet>(), List.of());
        }

        static Builder of(long expectedCapacity, IntObjectMap<List<NodeLabel>> labelTokenNodeLabelMapping) {
            List starNodeLabelMappings = (List)labelTokenNodeLabelMapping.getOrDefault(-1, List.of());
            Map<NodeLabel, HugeAtomicGrowingBitSet> nodeLabelBitSetMap = Builder.prepareLabelMap(labelTokenNodeLabelMapping, () -> HugeAtomicGrowingBitSet.create(expectedCapacity));
            return new Builder(expectedCapacity, nodeLabelBitSetMap, starNodeLabelMappings);
        }

        private static <T> Map<NodeLabel, T> prepareLabelMap(IntObjectMap<List<NodeLabel>> labelTokenNodeLabelMapping, Supplier<T> mapSupplier) {
            return StreamSupport.stream(labelTokenNodeLabelMapping.values().spliterator(), false).flatMap(cursor -> ((List)cursor.value).stream()).distinct().collect(Collectors.toMap(nodeLabel -> nodeLabel, nodeLabel -> mapSupplier.get()));
        }

        @Override
        public void addNodeIdToLabel(NodeLabel nodeLabel, long nodeId) {
            this.labelInformation.computeIfAbsent(nodeLabel, ignored -> HugeAtomicGrowingBitSet.create(this.expectedCapacity)).set(nodeId);
        }

        Map<NodeLabel, BitSet> buildInner(long nodeCount, LongUnaryOperator mappedIdFn) {
            return this.labelInformation.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> {
                HugeAtomicGrowingBitSet importBitSet = (HugeAtomicGrowingBitSet)e.getValue();
                BitSet internBitSet = new BitSet(nodeCount);
                importBitSet.forEachSetBit(neoId -> internBitSet.set(mappedIdFn.applyAsLong(neoId)));
                return internBitSet;
            }));
        }

        @Override
        public LabelInformation build(long nodeCount, LongUnaryOperator mappedIdFn) {
            Map<NodeLabel, BitSet> labelInformation = this.buildInner(nodeCount, mappedIdFn);
            if (labelInformation.isEmpty() && this.starNodeLabelMappings.isEmpty()) {
                return new SingleLabelInformation.Builder(NodeLabel.ALL_NODES).build(nodeCount, mappedIdFn);
            }
            if (labelInformation.size() == 1 && this.starNodeLabelMappings.isEmpty()) {
                return new SingleLabelInformation.Builder(labelInformation.keySet().iterator().next()).build(nodeCount, mappedIdFn);
            }
            for (NodeLabel starLabel : this.starNodeLabelMappings) {
                BitSet bitSet = new BitSet(nodeCount);
                bitSet.set(0L, nodeCount);
                labelInformation.put(starLabel, bitSet);
            }
            return new MultiLabelInformation(labelInformation);
        }
    }
}

