/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.loading;

import com.carrotsearch.hppc.BitSet;
import com.carrotsearch.hppc.IntObjectMap;
import java.util.Collection;
import java.util.List;
import java.util.PrimitiveIterator;
import java.util.Set;
import java.util.function.LongUnaryOperator;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.api.IdMap;
import org.neo4j.gds.core.loading.MultiLabelInformation;
import org.neo4j.gds.core.loading.SingleLabelInformation;

public interface LabelInformation {
    public static Builder single(NodeLabel singleLabel) {
        return new SingleLabelInformation.Builder(singleLabel);
    }

    public static Builder builder(long expectedCapacity) {
        return MultiLabelInformation.Builder.of(expectedCapacity);
    }

    public static Builder builder(long expectedCapacity, IntObjectMap<List<NodeLabel>> labelTokenNodeLabelMapping) {
        return MultiLabelInformation.Builder.of(expectedCapacity, labelTokenNodeLabelMapping);
    }

    public boolean isEmpty();

    public Set<NodeLabel> labelSet();

    public void forEach(LabelInformationConsumer var1);

    public LabelInformation filter(Collection<NodeLabel> var1);

    public BitSet unionBitSet(Collection<NodeLabel> var1, long var2);

    public boolean hasLabel(long var1, NodeLabel var3);

    public Set<NodeLabel> availableNodeLabels();

    public List<NodeLabel> nodeLabelsForNodeId(long var1);

    public void forEachNodeLabel(long var1, IdMap.NodeLabelConsumer var3);

    public void validateNodeLabelFilter(Collection<NodeLabel> var1);

    public PrimitiveIterator.OfLong nodeIterator(Collection<NodeLabel> var1, long var2);

    public static interface Builder {
        public void addNodeIdToLabel(NodeLabel var1, long var2);

        public LabelInformation build(long var1, LongUnaryOperator var3);
    }

    public static interface LabelInformationConsumer {
        public boolean accept(NodeLabel var1, BitSet var2);
    }
}

