/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.loading;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.concurrent.ExecutorService;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.PropertyMapping;
import org.neo4j.gds.api.IdMap;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.compat.CompatIndexQuery;
import org.neo4j.gds.compat.Neo4jProxy;
import org.neo4j.gds.core.concurrency.ParallelUtil;
import org.neo4j.gds.core.loading.nodeproperties.NodePropertiesFromStoreBuilder;
import org.neo4j.gds.core.utils.ArrayUtil;
import org.neo4j.gds.core.utils.StatementAction;
import org.neo4j.gds.core.utils.TerminationFlag;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.transaction.TransactionContext;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.IndexReadSession;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexOrder;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.values.storable.NumberValue;
import org.neo4j.values.storable.Value;

public final class IndexedNodePropertyImporter
extends StatementAction {
    private final int concurrency;
    private final NodeLabel nodeLabel;
    private final PropertyMapping mapping;
    private final IndexDescriptor index;
    private final Optional<CompatIndexQuery> indexQuery;
    private final IdMap idMap;
    private final ProgressTracker progressTracker;
    private final TerminationFlag terminationFlag;
    @Nullable
    private final ExecutorService executorService;
    private final int propertyId;
    private final NodePropertiesFromStoreBuilder propertiesBuilder;
    private long imported;
    private long logged;

    IndexedNodePropertyImporter(int concurrency, TransactionContext tx, NodeLabel nodeLabel, PropertyMapping mapping, IndexDescriptor index, IdMap idMap, ProgressTracker progressTracker, TerminationFlag terminationFlag, @Nullable ExecutorService executorService, NodePropertiesFromStoreBuilder propertiesBuilder) {
        this(concurrency, tx, nodeLabel, mapping, index, Optional.empty(), idMap, progressTracker, terminationFlag, executorService, index.schema().getPropertyId(), propertiesBuilder);
    }

    private IndexedNodePropertyImporter(IndexedNodePropertyImporter from, CompatIndexQuery indexQuery) {
        this(from.concurrency, from.tx, from.nodeLabel, from.mapping, from.index, Optional.of(indexQuery), from.idMap, from.progressTracker, from.terminationFlag, from.executorService, from.propertyId, from.propertiesBuilder);
    }

    private IndexedNodePropertyImporter(int concurrency, TransactionContext tx, NodeLabel nodeLabel, PropertyMapping mapping, IndexDescriptor index, Optional<CompatIndexQuery> indexQuery, IdMap idMap, ProgressTracker progressTracker, TerminationFlag terminationFlag, @Nullable ExecutorService executorService, int propertyId, NodePropertiesFromStoreBuilder propertiesBuilder) {
        super(tx);
        this.concurrency = concurrency;
        this.nodeLabel = nodeLabel;
        this.mapping = mapping;
        this.index = index;
        this.indexQuery = indexQuery;
        this.idMap = idMap;
        this.progressTracker = progressTracker;
        this.terminationFlag = terminationFlag;
        this.executorService = executorService;
        this.propertyId = propertyId;
        this.propertiesBuilder = propertiesBuilder;
    }

    @Override
    public String threadName() {
        return "index-scan-" + this.index.getName();
    }

    @Override
    public void accept(KernelTransaction ktx) throws Exception {
        Read read = ktx.dataRead();
        try (NodeValueIndexCursor indexCursor = Neo4jProxy.allocateNodeValueIndexCursor((KernelTransaction)ktx);){
            int[] propertyIds = this.index.schema().getPropertyIds();
            int propertyOffset = ArrayUtil.linearSearchIndex(propertyIds, propertyIds.length, this.propertyId);
            if (propertyOffset < 0) {
                return;
            }
            IndexReadSession indexReadSession = read.indexReadSession(this.index);
            if (this.indexQuery.isPresent()) {
                Neo4jProxy.nodeIndexSeek((Read)read, (IndexReadSession)indexReadSession, (NodeValueIndexCursor)indexCursor, (IndexOrder)IndexOrder.NONE, (boolean)true, (CompatIndexQuery)this.indexQuery.get());
            } else {
                List<IndexedNodePropertyImporter> parallelJobs;
                if (this.concurrency > 1 && ParallelUtil.canRunInParallel(this.executorService) && (parallelJobs = this.prepareParallelScan(read, indexReadSession, indexCursor, propertyOffset)) != null) {
                    ParallelUtil.run(parallelJobs, this.executorService);
                    return;
                }
                IndexQueryConstraints indexQueryConstraints = IndexQueryConstraints.unordered((boolean)true);
                read.nodeIndexScan(indexReadSession, indexCursor, indexQueryConstraints);
            }
            this.importFromCursor(indexCursor, propertyOffset);
        }
    }

    NodeLabel nodeLabel() {
        return this.nodeLabel;
    }

    PropertyMapping mapping() {
        return this.mapping;
    }

    long imported() {
        return this.imported;
    }

    NodePropertyValues build(IdMap idMap) {
        return this.propertiesBuilder.build(idMap);
    }

    @Nullable
    private List<IndexedNodePropertyImporter> prepareParallelScan(Read read, IndexReadSession indexReadSession, NodeValueIndexCursor indexCursor, int propertyOffset) throws Exception {
        CompatIndexQuery anyValue = Neo4jProxy.rangeAllIndexQuery((int)this.propertyId);
        Neo4jProxy.nodeIndexSeek((Read)read, (IndexReadSession)indexReadSession, (NodeValueIndexCursor)indexCursor, (IndexOrder)IndexOrder.ASCENDING, (boolean)true, (CompatIndexQuery)anyValue);
        OptionalDouble min = this.findFirst(indexCursor, propertyOffset);
        if (min.isPresent()) {
            Neo4jProxy.nodeIndexSeek((Read)read, (IndexReadSession)indexReadSession, (NodeValueIndexCursor)indexCursor, (IndexOrder)IndexOrder.DESCENDING, (boolean)true, (CompatIndexQuery)anyValue);
            OptionalDouble max = this.findFirst(indexCursor, propertyOffset);
            if (max.isPresent()) {
                double maxValue;
                double range;
                double batchSize;
                double minValue = min.getAsDouble();
                if (minValue == minValue + (batchSize = (range = (maxValue = Math.nextUp(max.getAsDouble())) - minValue) / (double)this.concurrency)) {
                    batchSize = Math.nextUp(minValue) - minValue;
                }
                ArrayList<IndexedNodePropertyImporter> jobs = new ArrayList<IndexedNodePropertyImporter>(this.concurrency);
                while (minValue < maxValue) {
                    CompatIndexQuery query = Neo4jProxy.rangeIndexQuery((int)this.propertyId, (double)minValue, (boolean)true, (double)(minValue + batchSize), (boolean)false);
                    jobs.add(new IndexedNodePropertyImporter(this, query));
                    minValue += batchSize;
                }
                return jobs;
            }
        }
        return null;
    }

    private OptionalDouble findFirst(NodeValueIndexCursor indexCursor, int propertyOffset) {
        while (indexCursor.next()) {
            Value propertyValue;
            double number;
            long node;
            long nodeId;
            if (!indexCursor.hasValue() || (nodeId = this.idMap.toMappedNodeId(node = indexCursor.nodeReference())) < 0L || !Double.isFinite(number = ((NumberValue)(propertyValue = indexCursor.propertyValue(propertyOffset))).doubleValue())) continue;
            return OptionalDouble.of(number);
        }
        return OptionalDouble.empty();
    }

    private void importFromCursor(NodeValueIndexCursor indexCursor, int propertyOffset) {
        while (indexCursor.next()) {
            long neoNodeId;
            long nodeId;
            if (!indexCursor.hasValue() || (nodeId = this.idMap.toMappedNodeId(neoNodeId = indexCursor.nodeReference())) < 0L) continue;
            Value propertyValue = indexCursor.propertyValue(propertyOffset);
            this.propertiesBuilder.set(neoNodeId, propertyValue);
            ++this.imported;
            if ((this.imported & 0x1FFFFL) != 0L) continue;
            this.progressTracker.logProgress(this.imported - this.logged);
            this.logged = this.imported;
            this.terminationFlag.assertRunning();
        }
    }
}

