/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.loading;

import com.carrotsearch.hppc.IntObjectMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.neo4j.gds.AbstractPropertyMappings;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.NodeProjection;
import org.neo4j.gds.PropertyMapping;
import org.neo4j.gds.PropertyMappings;
import org.neo4j.gds.annotation.ValueClass;
import org.neo4j.gds.compat.Neo4jProxy;
import org.neo4j.gds.config.GraphProjectFromStoreConfig;
import org.neo4j.gds.core.GraphDimensions;
import org.neo4j.gds.core.loading.ImmutableIndexedPropertyMapping;
import org.neo4j.gds.core.loading.ImmutableIndexedPropertyMappings;
import org.neo4j.gds.core.loading.ImmutableLoadablePropertyMappings;
import org.neo4j.gds.transaction.TransactionContext;
import org.neo4j.gds.utils.GdsFeatureToggles;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.SchemaReadCore;
import org.neo4j.internal.schema.IndexCapability;
import org.neo4j.internal.schema.IndexDescriptor;

final class IndexPropertyMappings {
    static LoadablePropertyMappings prepareProperties(GraphProjectFromStoreConfig graphProjectConfig, GraphDimensions graphDimensions, TransactionContext transaction) {
        Map<NodeLabel, PropertyMappings> storeLoadedProperties = graphProjectConfig.nodeProjections().projections().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((NodeProjection)entry.getValue()).properties()));
        return IndexPropertyMappings.prepareLoadableProperties(graphDimensions, transaction, storeLoadedProperties);
    }

    private static LoadablePropertyMappings prepareLoadableProperties(GraphDimensions dimensions, TransactionContext transaction, Map<NodeLabel, PropertyMappings> storeLoadedProperties) {
        if (dimensions.tokenNodeLabelMapping() == null || !GdsFeatureToggles.USE_PROPERTY_VALUE_INDEX.isEnabled()) {
            return ImmutableLoadablePropertyMappings.builder().putAllStoredProperties(storeLoadedProperties).build();
        }
        return (LoadablePropertyMappings)transaction.apply((tx, ktx) -> IndexPropertyMappings.prepareLoadableProperties(dimensions, tx.schema(), (SchemaReadCore)ktx.schemaRead(), storeLoadedProperties));
    }

    private static LoadablePropertyMappings prepareLoadableProperties(GraphDimensions dimensions, Schema schema, SchemaReadCore schemaRead, Map<NodeLabel, PropertyMappings> propertyMappingsByNodeLabel) {
        IntObjectMap nodeLabelMapping = Objects.requireNonNull(dimensions.tokenNodeLabelMapping());
        IntStream labelIds = StreamSupport.stream(nodeLabelMapping.keys().spliterator(), false).mapToInt(labelCursor -> labelCursor.value).filter(IndexPropertyMappings::labelIsCandidateForIndexScan);
        Stream scannableIndexes = labelIds.mapToObj(label -> IndexPropertyMappings.possibleIndexesForLabel(schema, schemaRead, label)).flatMap(Function.identity());
        Map<NodeLabel, Map<Integer, IndexDescriptor>> indexPerLabel = scannableIndexes.flatMap(index -> IndexPropertyMappings.conflateIndexToLabels((IntObjectMap<List<NodeLabel>>)nodeLabelMapping, index)).collect(Collectors.groupingBy(Map.Entry::getKey, Collectors.toMap(id -> ((IndexDescriptor)id.getValue()).schema().getPropertyId(), Map.Entry::getValue)));
        return IndexPropertyMappings.groupIndexes(dimensions, propertyMappingsByNodeLabel, indexPerLabel);
    }

    private static boolean labelIsCandidateForIndexScan(int labelId) {
        return labelId != -1;
    }

    private static Stream<IndexDescriptor> possibleIndexesForLabel(Schema schema, SchemaReadCore schemaRead, int labelId) {
        return Iterators.stream((Iterator)schemaRead.indexesGetForLabel(labelId)).filter(index -> IndexPropertyMappings.indexIsCandidateForIndexScan(schema, index));
    }

    private static boolean indexIsCandidateForIndexScan(Schema schema, IndexDescriptor index) {
        if (index == IndexDescriptor.NO_INDEX) {
            return false;
        }
        if (index.schema().getPropertyIds().length != 1) {
            return false;
        }
        if (Neo4jProxy.isNotNumericIndex((IndexCapability)index.getCapability())) {
            return false;
        }
        try {
            schema.awaitIndexOnline(index.getName(), 1L, TimeUnit.SECONDS);
            return true;
        }
        catch (RuntimeException notOnline) {
            return false;
        }
    }

    private static Stream<Map.Entry<NodeLabel, IndexDescriptor>> conflateIndexToLabels(IntObjectMap<List<NodeLabel>> labelMapping, IndexDescriptor index) {
        List nodeLabels = (List)labelMapping.getOrDefault(index.schema().getLabelId(), List.of());
        return nodeLabels.stream().map(label -> Map.entry(label, index));
    }

    private static LoadablePropertyMappings groupIndexes(GraphDimensions dimensions, Map<NodeLabel, PropertyMappings> propertyMappingsByNodeLabel, Map<NodeLabel, Map<Integer, IndexDescriptor>> availablePropertyIndexes) {
        ImmutableLoadablePropertyMappings.Builder builder = ImmutableLoadablePropertyMappings.builder();
        availablePropertyIndexes.forEach((nodeLabel, propertyKeyToIndex) -> {
            IndexedPropertyMappings indexMappings;
            PropertyMappings propertyMappings = (PropertyMappings)propertyMappingsByNodeLabel.remove(nodeLabel);
            if (propertyMappings == null) {
                return;
            }
            AbstractPropertyMappings.Builder storeMappingsBuilder = PropertyMappings.builder();
            ImmutableIndexedPropertyMappings.Builder indexMappingsBuilder = ImmutableIndexedPropertyMappings.builder();
            propertyMappings.forEach(mapping -> {
                Integer propertyKey = (Integer)dimensions.nodePropertyTokens().get(mapping.neoPropertyKey());
                if (propertyKey == null) {
                    return;
                }
                IndexDescriptor indexDescriptor = (IndexDescriptor)propertyKeyToIndex.get(propertyKey);
                if (indexDescriptor != null) {
                    IndexedPropertyMapping propertyMapping = ImmutableIndexedPropertyMapping.of(mapping, indexDescriptor);
                    indexMappingsBuilder.addMapping(propertyMapping);
                } else {
                    storeMappingsBuilder.addMapping(mapping);
                }
            });
            PropertyMappings storeMappings = storeMappingsBuilder.build();
            if (storeMappings.hasMappings()) {
                builder.putStoredProperty((NodeLabel)nodeLabel, storeMappings);
            }
            if (!(indexMappings = indexMappingsBuilder.build()).mappings().isEmpty()) {
                builder.putIndexedProperty((NodeLabel)nodeLabel, indexMappings);
            }
        });
        builder.putAllStoredProperties(propertyMappingsByNodeLabel);
        return builder.build();
    }

    private IndexPropertyMappings() {
    }

    @ValueClass
    public static interface LoadablePropertyMappings {
        public Map<NodeLabel, PropertyMappings> storedProperties();

        public Map<NodeLabel, IndexedPropertyMappings> indexedProperties();
    }

    @ValueClass
    static interface IndexedPropertyMappings {
        public List<IndexedPropertyMapping> mappings();
    }

    @ValueClass
    static interface IndexedPropertyMapping {
        public PropertyMapping property();

        public IndexDescriptor index();
    }
}

