/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.loading;

import java.util.HashMap;
import java.util.Map;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.dbms.api.DatabaseNotFoundException;
import org.neo4j.gds.api.DatabaseId;
import org.neo4j.gds.core.loading.GraphStoreCatalog;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.event.DatabaseEventContext;
import org.neo4j.graphdb.event.DatabaseEventListener;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

class InMemoryGraphTrackerLifecycleAdapter
extends LifecycleAdapter
implements DatabaseEventListener {
    private final DatabaseManagementService dbms;
    private final Map<String, DatabaseId> databaseIdMapping;

    InMemoryGraphTrackerLifecycleAdapter(DatabaseManagementService dbms) {
        this.dbms = dbms;
        this.databaseIdMapping = new HashMap<String, DatabaseId>();
    }

    public void init() throws Exception {
        this.dbms.registerDatabaseEventListener((DatabaseEventListener)this);
    }

    public void shutdown() throws Exception {
        this.dbms.unregisterDatabaseEventListener((DatabaseEventListener)this);
    }

    public void databaseShutdown(DatabaseEventContext eventContext) {
        this.databaseIsShuttingDown(eventContext.getDatabaseName());
    }

    public void databasePanic(DatabaseEventContext eventContext) {
        this.databaseIsShuttingDown(eventContext.getDatabaseName());
    }

    public void databaseCreate(DatabaseEventContext eventContext) {
        String databaseName = eventContext.getDatabaseName();
        GraphDatabaseService db = this.dbms.database(databaseName);
        this.databaseIdMapping.put(databaseName, DatabaseId.of(db));
    }

    public void databaseDrop(DatabaseEventContext eventContext) {
        this.databaseIdMapping.remove(eventContext.getDatabaseName());
    }

    private void databaseIsShuttingDown(String databaseName) {
        if (!this.databaseIdMapping.containsKey(databaseName)) {
            throw new DatabaseNotFoundException(databaseName);
        }
        GraphStoreCatalog.removeAllLoadedGraphs(this.databaseIdMapping.get(databaseName));
    }

    public void databaseStart(DatabaseEventContext eventContext) {
    }
}

