/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.loading;

import java.util.OptionalInt;
import org.neo4j.gds.mem.BitUtil;
import org.neo4j.gds.utils.GdsFeatureToggles;
import org.neo4j.gds.utils.StringFormatting;

public final class ImportSizing {
    private static final long MAX_PAGE_SIZE = BitUtil.previousPowerOfTwo((int)Integer.MAX_VALUE);
    public static final long MIN_PAGE_SIZE = 1024L;
    private static final String TOO_MANY_PAGES_REQUIRED = "Importing %d nodes would need %d arrays of %d-long nested arrays each, which cannot be created.";
    private final int totalThreads;
    private final int numberOfPages;
    private final OptionalInt pageSize;

    private ImportSizing(int totalThreads, int numberOfPages, OptionalInt pageSize) {
        this.totalThreads = totalThreads;
        this.numberOfPages = numberOfPages;
        this.pageSize = pageSize;
    }

    public static ImportSizing of(int concurrency, long nodeCount) {
        return ImportSizing.determineBestThreadSize(nodeCount, concurrency);
    }

    public static ImportSizing of(int concurrency) {
        return ImportSizing.determineBestThreadSize(concurrency);
    }

    private static ImportSizing determineBestThreadSize(long nodeCount, long targetThreads) {
        long pageSize = BitUtil.ceilDiv((long)nodeCount, (long)(targetThreads * (long)GdsFeatureToggles.PAGES_PER_THREAD.get()));
        pageSize = BitUtil.previousPowerOfTwo((long)pageSize);
        pageSize = Math.min(MAX_PAGE_SIZE, pageSize);
        pageSize = Math.max(1024L, pageSize);
        long numberOfPages = BitUtil.ceilDiv((long)nodeCount, (long)pageSize);
        while (numberOfPages > MAX_PAGE_SIZE && pageSize <= MAX_PAGE_SIZE) {
            numberOfPages = BitUtil.ceilDiv((long)nodeCount, (long)(pageSize <<= 1));
        }
        if (numberOfPages > MAX_PAGE_SIZE || pageSize > MAX_PAGE_SIZE) {
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)TOO_MANY_PAGES_REQUIRED, (Object[])new Object[]{nodeCount, numberOfPages, pageSize}));
        }
        return new ImportSizing((int)targetThreads, (int)numberOfPages, OptionalInt.of((int)pageSize));
    }

    private static ImportSizing determineBestThreadSize(long targetThreads) {
        long numberOfPages = targetThreads * (long)GdsFeatureToggles.PAGES_PER_THREAD.get();
        numberOfPages = BitUtil.nextHighestPowerOfTwo((long)numberOfPages);
        numberOfPages = Math.min(MAX_PAGE_SIZE, numberOfPages);
        return new ImportSizing((int)targetThreads, (int)numberOfPages, OptionalInt.empty());
    }

    int threadCount() {
        return this.totalThreads;
    }

    int numberOfPages() {
        return this.numberOfPages;
    }

    OptionalInt pageSize() {
        return this.pageSize;
    }
}

