/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.loading;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.neo4j.gds.core.loading.GraphStoreCatalog;

@ParametersAreNonnullByDefault
@Generated(from="GraphStoreCatalog.UserCatalog.UserCatalogKey", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableUserCatalogKey
implements GraphStoreCatalog.UserCatalog.UserCatalogKey {
    private final String graphName;
    private final String databaseName;

    private ImmutableUserCatalogKey(String graphName, String databaseName) {
        this.graphName = Objects.requireNonNull(graphName, "graphName");
        this.databaseName = Objects.requireNonNull(databaseName, "databaseName");
    }

    private ImmutableUserCatalogKey(ImmutableUserCatalogKey original, String graphName, String databaseName) {
        this.graphName = graphName;
        this.databaseName = databaseName;
    }

    @Override
    public String graphName() {
        return this.graphName;
    }

    @Override
    public String databaseName() {
        return this.databaseName;
    }

    public final ImmutableUserCatalogKey withGraphName(String value) {
        String newValue = Objects.requireNonNull(value, "graphName");
        if (this.graphName.equals(newValue)) {
            return this;
        }
        return new ImmutableUserCatalogKey(this, newValue, this.databaseName);
    }

    public final ImmutableUserCatalogKey withDatabaseName(String value) {
        String newValue = Objects.requireNonNull(value, "databaseName");
        if (this.databaseName.equals(newValue)) {
            return this;
        }
        return new ImmutableUserCatalogKey(this, this.graphName, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUserCatalogKey && this.equalTo((ImmutableUserCatalogKey)another);
    }

    private boolean equalTo(ImmutableUserCatalogKey another) {
        return this.graphName.equals(another.graphName) && this.databaseName.equals(another.databaseName);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.graphName.hashCode();
        h += (h << 5) + this.databaseName.hashCode();
        return h;
    }

    public String toString() {
        return "UserCatalogKey{graphName=" + this.graphName + ", databaseName=" + this.databaseName + "}";
    }

    public static GraphStoreCatalog.UserCatalog.UserCatalogKey of(String graphName, String databaseName) {
        return new ImmutableUserCatalogKey(graphName, databaseName);
    }

    public static GraphStoreCatalog.UserCatalog.UserCatalogKey copyOf(GraphStoreCatalog.UserCatalog.UserCatalogKey instance) {
        if (instance instanceof ImmutableUserCatalogKey) {
            return (ImmutableUserCatalogKey)instance;
        }
        return ImmutableUserCatalogKey.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="GraphStoreCatalog.UserCatalog.UserCatalogKey", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_GRAPH_NAME = 1L;
        private static final long INIT_BIT_DATABASE_NAME = 2L;
        private long initBits = 3L;
        @Nullable
        private String graphName;
        @Nullable
        private String databaseName;

        private Builder() {
        }

        public final Builder from(GraphStoreCatalog.UserCatalog.UserCatalogKey instance) {
            Objects.requireNonNull(instance, "instance");
            this.graphName(instance.graphName());
            this.databaseName(instance.databaseName());
            return this;
        }

        public final Builder graphName(String graphName) {
            this.graphName = Objects.requireNonNull(graphName, "graphName");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder databaseName(String databaseName) {
            this.databaseName = Objects.requireNonNull(databaseName, "databaseName");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public Builder clear() {
            this.initBits = 3L;
            this.graphName = null;
            this.databaseName = null;
            return this;
        }

        public GraphStoreCatalog.UserCatalog.UserCatalogKey build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUserCatalogKey(null, this.graphName, this.databaseName);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("graphName");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("databaseName");
            }
            return "Cannot build UserCatalogKey, some of required attributes are not set " + attributes;
        }
    }
}

