/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.loading;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.neo4j.gds.RelationshipProjection;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.core.loading.SingleTypeRelationshipImporter;

@ParametersAreNonnullByDefault
@Generated(from="SingleTypeRelationshipImporter.SingleTypeRelationshipImportContext", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableSingleTypeRelationshipImportContext
implements SingleTypeRelationshipImporter.SingleTypeRelationshipImportContext {
    private final RelationshipType relationshipType;
    private final RelationshipProjection relationshipProjection;
    private final SingleTypeRelationshipImporter singleTypeRelationshipImporter;

    private ImmutableSingleTypeRelationshipImportContext(RelationshipType relationshipType, RelationshipProjection relationshipProjection, SingleTypeRelationshipImporter singleTypeRelationshipImporter) {
        this.relationshipType = Objects.requireNonNull(relationshipType, "relationshipType");
        this.relationshipProjection = Objects.requireNonNull(relationshipProjection, "relationshipProjection");
        this.singleTypeRelationshipImporter = Objects.requireNonNull(singleTypeRelationshipImporter, "singleTypeRelationshipImporter");
    }

    private ImmutableSingleTypeRelationshipImportContext(ImmutableSingleTypeRelationshipImportContext original, RelationshipType relationshipType, RelationshipProjection relationshipProjection, SingleTypeRelationshipImporter singleTypeRelationshipImporter) {
        this.relationshipType = relationshipType;
        this.relationshipProjection = relationshipProjection;
        this.singleTypeRelationshipImporter = singleTypeRelationshipImporter;
    }

    @Override
    public RelationshipType relationshipType() {
        return this.relationshipType;
    }

    @Override
    public RelationshipProjection relationshipProjection() {
        return this.relationshipProjection;
    }

    @Override
    public SingleTypeRelationshipImporter singleTypeRelationshipImporter() {
        return this.singleTypeRelationshipImporter;
    }

    public final ImmutableSingleTypeRelationshipImportContext withRelationshipType(RelationshipType value) {
        if (this.relationshipType == value) {
            return this;
        }
        RelationshipType newValue = Objects.requireNonNull(value, "relationshipType");
        return new ImmutableSingleTypeRelationshipImportContext(this, newValue, this.relationshipProjection, this.singleTypeRelationshipImporter);
    }

    public final ImmutableSingleTypeRelationshipImportContext withRelationshipProjection(RelationshipProjection value) {
        if (this.relationshipProjection == value) {
            return this;
        }
        RelationshipProjection newValue = Objects.requireNonNull(value, "relationshipProjection");
        return new ImmutableSingleTypeRelationshipImportContext(this, this.relationshipType, newValue, this.singleTypeRelationshipImporter);
    }

    public final ImmutableSingleTypeRelationshipImportContext withSingleTypeRelationshipImporter(SingleTypeRelationshipImporter value) {
        if (this.singleTypeRelationshipImporter == value) {
            return this;
        }
        SingleTypeRelationshipImporter newValue = Objects.requireNonNull(value, "singleTypeRelationshipImporter");
        return new ImmutableSingleTypeRelationshipImportContext(this, this.relationshipType, this.relationshipProjection, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSingleTypeRelationshipImportContext && this.equalTo((ImmutableSingleTypeRelationshipImportContext)another);
    }

    private boolean equalTo(ImmutableSingleTypeRelationshipImportContext another) {
        return this.relationshipType.equals((Object)another.relationshipType) && this.relationshipProjection.equals((Object)another.relationshipProjection) && this.singleTypeRelationshipImporter.equals(another.singleTypeRelationshipImporter);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.relationshipType.hashCode();
        h += (h << 5) + this.relationshipProjection.hashCode();
        h += (h << 5) + this.singleTypeRelationshipImporter.hashCode();
        return h;
    }

    public String toString() {
        return "SingleTypeRelationshipImportContext{relationshipType=" + this.relationshipType + ", relationshipProjection=" + this.relationshipProjection + ", singleTypeRelationshipImporter=" + this.singleTypeRelationshipImporter + "}";
    }

    public static SingleTypeRelationshipImporter.SingleTypeRelationshipImportContext of(RelationshipType relationshipType, RelationshipProjection relationshipProjection, SingleTypeRelationshipImporter singleTypeRelationshipImporter) {
        return new ImmutableSingleTypeRelationshipImportContext(relationshipType, relationshipProjection, singleTypeRelationshipImporter);
    }

    public static SingleTypeRelationshipImporter.SingleTypeRelationshipImportContext copyOf(SingleTypeRelationshipImporter.SingleTypeRelationshipImportContext instance) {
        if (instance instanceof ImmutableSingleTypeRelationshipImportContext) {
            return (ImmutableSingleTypeRelationshipImportContext)instance;
        }
        return ImmutableSingleTypeRelationshipImportContext.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="SingleTypeRelationshipImporter.SingleTypeRelationshipImportContext", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_RELATIONSHIP_TYPE = 1L;
        private static final long INIT_BIT_RELATIONSHIP_PROJECTION = 2L;
        private static final long INIT_BIT_SINGLE_TYPE_RELATIONSHIP_IMPORTER = 4L;
        private long initBits = 7L;
        @Nullable
        private RelationshipType relationshipType;
        @Nullable
        private RelationshipProjection relationshipProjection;
        @Nullable
        private SingleTypeRelationshipImporter singleTypeRelationshipImporter;

        private Builder() {
        }

        public final Builder from(SingleTypeRelationshipImporter.SingleTypeRelationshipImportContext instance) {
            Objects.requireNonNull(instance, "instance");
            this.relationshipType(instance.relationshipType());
            this.relationshipProjection(instance.relationshipProjection());
            this.singleTypeRelationshipImporter(instance.singleTypeRelationshipImporter());
            return this;
        }

        public final Builder relationshipType(RelationshipType relationshipType) {
            this.relationshipType = Objects.requireNonNull(relationshipType, "relationshipType");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder relationshipProjection(RelationshipProjection relationshipProjection) {
            this.relationshipProjection = Objects.requireNonNull(relationshipProjection, "relationshipProjection");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder singleTypeRelationshipImporter(SingleTypeRelationshipImporter singleTypeRelationshipImporter) {
            this.singleTypeRelationshipImporter = Objects.requireNonNull(singleTypeRelationshipImporter, "singleTypeRelationshipImporter");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public Builder clear() {
            this.initBits = 7L;
            this.relationshipType = null;
            this.relationshipProjection = null;
            this.singleTypeRelationshipImporter = null;
            return this;
        }

        public SingleTypeRelationshipImporter.SingleTypeRelationshipImportContext build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSingleTypeRelationshipImportContext(null, this.relationshipType, this.relationshipProjection, this.singleTypeRelationshipImporter);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("relationshipType");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("relationshipProjection");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("singleTypeRelationshipImporter");
            }
            return "Cannot build SingleTypeRelationshipImportContext, some of required attributes are not set " + attributes;
        }
    }
}

