/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.loading;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.api.RelationshipPropertyStore;
import org.neo4j.gds.api.Relationships;
import org.neo4j.gds.core.loading.RelationshipsAndProperties;

@ParametersAreNonnullByDefault
@Generated(from="RelationshipsAndProperties", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableRelationshipsAndProperties
implements RelationshipsAndProperties {
    private final Map<RelationshipType, Relationships.Topology> relationships;
    private final Map<RelationshipType, RelationshipPropertyStore> properties;

    private ImmutableRelationshipsAndProperties(Map<? extends RelationshipType, ? extends Relationships.Topology> relationships, Map<? extends RelationshipType, ? extends RelationshipPropertyStore> properties) {
        this.relationships = ImmutableRelationshipsAndProperties.createUnmodifiableMap(true, false, relationships);
        this.properties = ImmutableRelationshipsAndProperties.createUnmodifiableMap(true, false, properties);
    }

    private ImmutableRelationshipsAndProperties(ImmutableRelationshipsAndProperties original, Map<RelationshipType, Relationships.Topology> relationships, Map<RelationshipType, RelationshipPropertyStore> properties) {
        this.relationships = relationships;
        this.properties = properties;
    }

    @Override
    public Map<RelationshipType, Relationships.Topology> relationships() {
        return this.relationships;
    }

    @Override
    public Map<RelationshipType, RelationshipPropertyStore> properties() {
        return this.properties;
    }

    public final ImmutableRelationshipsAndProperties withRelationships(Map<? extends RelationshipType, ? extends Relationships.Topology> entries) {
        if (this.relationships == entries) {
            return this;
        }
        Map<RelationshipType, Relationships.Topology> newValue = ImmutableRelationshipsAndProperties.createUnmodifiableMap(true, false, entries);
        return new ImmutableRelationshipsAndProperties(this, newValue, this.properties);
    }

    public final ImmutableRelationshipsAndProperties withProperties(Map<? extends RelationshipType, ? extends RelationshipPropertyStore> entries) {
        if (this.properties == entries) {
            return this;
        }
        Map<RelationshipType, RelationshipPropertyStore> newValue = ImmutableRelationshipsAndProperties.createUnmodifiableMap(true, false, entries);
        return new ImmutableRelationshipsAndProperties(this, this.relationships, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRelationshipsAndProperties && this.equalTo((ImmutableRelationshipsAndProperties)another);
    }

    private boolean equalTo(ImmutableRelationshipsAndProperties another) {
        return this.relationships.equals(another.relationships) && this.properties.equals(another.properties);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.relationships.hashCode();
        h += (h << 5) + this.properties.hashCode();
        return h;
    }

    public String toString() {
        return "RelationshipsAndProperties{relationships=" + this.relationships + ", properties=" + this.properties + "}";
    }

    public static RelationshipsAndProperties of(Map<? extends RelationshipType, ? extends Relationships.Topology> relationships, Map<? extends RelationshipType, ? extends RelationshipPropertyStore> properties) {
        return new ImmutableRelationshipsAndProperties(relationships, properties);
    }

    public static RelationshipsAndProperties copyOf(RelationshipsAndProperties instance) {
        if (instance instanceof ImmutableRelationshipsAndProperties) {
            return (ImmutableRelationshipsAndProperties)instance;
        }
        return ImmutableRelationshipsAndProperties.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="RelationshipsAndProperties", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private Map<RelationshipType, Relationships.Topology> relationships = null;
        private Map<RelationshipType, RelationshipPropertyStore> properties = null;

        private Builder() {
        }

        public final Builder from(RelationshipsAndProperties instance) {
            Objects.requireNonNull(instance, "instance");
            this.putAllRelationships(instance.relationships());
            this.putAllProperties(instance.properties());
            return this;
        }

        public final Builder putRelationship(RelationshipType key, Relationships.Topology value) {
            if (this.relationships == null) {
                this.relationships = new LinkedHashMap<RelationshipType, Relationships.Topology>();
            }
            this.relationships.put(Objects.requireNonNull(key, "relationships key"), Objects.requireNonNull(value, "relationships value"));
            return this;
        }

        public final Builder putRelationship(Map.Entry<? extends RelationshipType, ? extends Relationships.Topology> entry) {
            if (this.relationships == null) {
                this.relationships = new LinkedHashMap<RelationshipType, Relationships.Topology>();
            }
            RelationshipType k = entry.getKey();
            Relationships.Topology v = entry.getValue();
            this.relationships.put(Objects.requireNonNull(k, "relationships key"), Objects.requireNonNull(v, "relationships value"));
            return this;
        }

        public final Builder relationships(Map<? extends RelationshipType, ? extends Relationships.Topology> entries) {
            this.relationships = new LinkedHashMap<RelationshipType, Relationships.Topology>();
            return this.putAllRelationships(entries);
        }

        public final Builder putAllRelationships(Map<? extends RelationshipType, ? extends Relationships.Topology> entries) {
            if (this.relationships == null) {
                this.relationships = new LinkedHashMap<RelationshipType, Relationships.Topology>();
            }
            for (Map.Entry<? extends RelationshipType, ? extends Relationships.Topology> e : entries.entrySet()) {
                RelationshipType k = e.getKey();
                Relationships.Topology v = e.getValue();
                this.relationships.put(Objects.requireNonNull(k, "relationships key"), Objects.requireNonNull(v, "relationships value"));
            }
            return this;
        }

        public final Builder putProperty(RelationshipType key, RelationshipPropertyStore value) {
            if (this.properties == null) {
                this.properties = new LinkedHashMap<RelationshipType, RelationshipPropertyStore>();
            }
            this.properties.put(Objects.requireNonNull(key, "properties key"), Objects.requireNonNull(value, "properties value"));
            return this;
        }

        public final Builder putProperty(Map.Entry<? extends RelationshipType, ? extends RelationshipPropertyStore> entry) {
            if (this.properties == null) {
                this.properties = new LinkedHashMap<RelationshipType, RelationshipPropertyStore>();
            }
            RelationshipType k = entry.getKey();
            RelationshipPropertyStore v = entry.getValue();
            this.properties.put(Objects.requireNonNull(k, "properties key"), Objects.requireNonNull(v, "properties value"));
            return this;
        }

        public final Builder properties(Map<? extends RelationshipType, ? extends RelationshipPropertyStore> entries) {
            this.properties = new LinkedHashMap<RelationshipType, RelationshipPropertyStore>();
            return this.putAllProperties(entries);
        }

        public final Builder putAllProperties(Map<? extends RelationshipType, ? extends RelationshipPropertyStore> entries) {
            if (this.properties == null) {
                this.properties = new LinkedHashMap<RelationshipType, RelationshipPropertyStore>();
            }
            for (Map.Entry<? extends RelationshipType, ? extends RelationshipPropertyStore> e : entries.entrySet()) {
                RelationshipType k = e.getKey();
                RelationshipPropertyStore v = e.getValue();
                this.properties.put(Objects.requireNonNull(k, "properties key"), Objects.requireNonNull(v, "properties value"));
            }
            return this;
        }

        public Builder clear() {
            if (this.relationships != null) {
                this.relationships.clear();
            }
            if (this.properties != null) {
                this.properties.clear();
            }
            return this;
        }

        public RelationshipsAndProperties build() {
            return new ImmutableRelationshipsAndProperties(null, this.relationships == null ? Collections.emptyMap() : ImmutableRelationshipsAndProperties.createUnmodifiableMap(false, false, this.relationships), this.properties == null ? Collections.emptyMap() : ImmutableRelationshipsAndProperties.createUnmodifiableMap(false, false, this.properties));
        }
    }
}

