/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.loading;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.PropertyMappings;
import org.neo4j.gds.core.loading.IndexPropertyMappings;

@ParametersAreNonnullByDefault
@Generated(from="IndexPropertyMappings.LoadablePropertyMappings", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableLoadablePropertyMappings
implements IndexPropertyMappings.LoadablePropertyMappings {
    private final Map<NodeLabel, PropertyMappings> storedProperties;
    private final Map<NodeLabel, IndexPropertyMappings.IndexedPropertyMappings> indexedProperties;

    private ImmutableLoadablePropertyMappings(Map<? extends NodeLabel, ? extends PropertyMappings> storedProperties, Map<? extends NodeLabel, ? extends IndexPropertyMappings.IndexedPropertyMappings> indexedProperties) {
        this.storedProperties = ImmutableLoadablePropertyMappings.createUnmodifiableMap(true, false, storedProperties);
        this.indexedProperties = ImmutableLoadablePropertyMappings.createUnmodifiableMap(true, false, indexedProperties);
    }

    private ImmutableLoadablePropertyMappings(ImmutableLoadablePropertyMappings original, Map<NodeLabel, PropertyMappings> storedProperties, Map<NodeLabel, IndexPropertyMappings.IndexedPropertyMappings> indexedProperties) {
        this.storedProperties = storedProperties;
        this.indexedProperties = indexedProperties;
    }

    @Override
    public Map<NodeLabel, PropertyMappings> storedProperties() {
        return this.storedProperties;
    }

    @Override
    public Map<NodeLabel, IndexPropertyMappings.IndexedPropertyMappings> indexedProperties() {
        return this.indexedProperties;
    }

    public final ImmutableLoadablePropertyMappings withStoredProperties(Map<? extends NodeLabel, ? extends PropertyMappings> entries) {
        if (this.storedProperties == entries) {
            return this;
        }
        Map<NodeLabel, PropertyMappings> newValue = ImmutableLoadablePropertyMappings.createUnmodifiableMap(true, false, entries);
        return new ImmutableLoadablePropertyMappings(this, newValue, this.indexedProperties);
    }

    public final ImmutableLoadablePropertyMappings withIndexedProperties(Map<? extends NodeLabel, ? extends IndexPropertyMappings.IndexedPropertyMappings> entries) {
        if (this.indexedProperties == entries) {
            return this;
        }
        Map<NodeLabel, IndexPropertyMappings.IndexedPropertyMappings> newValue = ImmutableLoadablePropertyMappings.createUnmodifiableMap(true, false, entries);
        return new ImmutableLoadablePropertyMappings(this, this.storedProperties, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableLoadablePropertyMappings && this.equalTo((ImmutableLoadablePropertyMappings)another);
    }

    private boolean equalTo(ImmutableLoadablePropertyMappings another) {
        return this.storedProperties.equals(another.storedProperties) && this.indexedProperties.equals(another.indexedProperties);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.storedProperties.hashCode();
        h += (h << 5) + this.indexedProperties.hashCode();
        return h;
    }

    public String toString() {
        return "LoadablePropertyMappings{storedProperties=" + this.storedProperties + ", indexedProperties=" + this.indexedProperties + "}";
    }

    public static IndexPropertyMappings.LoadablePropertyMappings of(Map<? extends NodeLabel, ? extends PropertyMappings> storedProperties, Map<? extends NodeLabel, ? extends IndexPropertyMappings.IndexedPropertyMappings> indexedProperties) {
        return new ImmutableLoadablePropertyMappings(storedProperties, indexedProperties);
    }

    public static IndexPropertyMappings.LoadablePropertyMappings copyOf(IndexPropertyMappings.LoadablePropertyMappings instance) {
        if (instance instanceof ImmutableLoadablePropertyMappings) {
            return (ImmutableLoadablePropertyMappings)instance;
        }
        return ImmutableLoadablePropertyMappings.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="IndexPropertyMappings.LoadablePropertyMappings", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private Map<NodeLabel, PropertyMappings> storedProperties = null;
        private Map<NodeLabel, IndexPropertyMappings.IndexedPropertyMappings> indexedProperties = null;

        private Builder() {
        }

        public final Builder from(IndexPropertyMappings.LoadablePropertyMappings instance) {
            Objects.requireNonNull(instance, "instance");
            this.putAllStoredProperties(instance.storedProperties());
            this.putAllIndexedProperties(instance.indexedProperties());
            return this;
        }

        public final Builder putStoredProperty(NodeLabel key, PropertyMappings value) {
            if (this.storedProperties == null) {
                this.storedProperties = new LinkedHashMap<NodeLabel, PropertyMappings>();
            }
            this.storedProperties.put(Objects.requireNonNull(key, "storedProperties key"), Objects.requireNonNull(value, "storedProperties value"));
            return this;
        }

        public final Builder putStoredProperty(Map.Entry<? extends NodeLabel, ? extends PropertyMappings> entry) {
            if (this.storedProperties == null) {
                this.storedProperties = new LinkedHashMap<NodeLabel, PropertyMappings>();
            }
            NodeLabel k = entry.getKey();
            PropertyMappings v = entry.getValue();
            this.storedProperties.put(Objects.requireNonNull(k, "storedProperties key"), Objects.requireNonNull(v, "storedProperties value"));
            return this;
        }

        public final Builder storedProperties(Map<? extends NodeLabel, ? extends PropertyMappings> entries) {
            this.storedProperties = new LinkedHashMap<NodeLabel, PropertyMappings>();
            return this.putAllStoredProperties(entries);
        }

        public final Builder putAllStoredProperties(Map<? extends NodeLabel, ? extends PropertyMappings> entries) {
            if (this.storedProperties == null) {
                this.storedProperties = new LinkedHashMap<NodeLabel, PropertyMappings>();
            }
            for (Map.Entry<? extends NodeLabel, ? extends PropertyMappings> e : entries.entrySet()) {
                NodeLabel k = e.getKey();
                PropertyMappings v = e.getValue();
                this.storedProperties.put(Objects.requireNonNull(k, "storedProperties key"), Objects.requireNonNull(v, "storedProperties value"));
            }
            return this;
        }

        public final Builder putIndexedProperty(NodeLabel key, IndexPropertyMappings.IndexedPropertyMappings value) {
            if (this.indexedProperties == null) {
                this.indexedProperties = new LinkedHashMap<NodeLabel, IndexPropertyMappings.IndexedPropertyMappings>();
            }
            this.indexedProperties.put(Objects.requireNonNull(key, "indexedProperties key"), Objects.requireNonNull(value, "indexedProperties value"));
            return this;
        }

        public final Builder putIndexedProperty(Map.Entry<? extends NodeLabel, ? extends IndexPropertyMappings.IndexedPropertyMappings> entry) {
            if (this.indexedProperties == null) {
                this.indexedProperties = new LinkedHashMap<NodeLabel, IndexPropertyMappings.IndexedPropertyMappings>();
            }
            NodeLabel k = entry.getKey();
            IndexPropertyMappings.IndexedPropertyMappings v = entry.getValue();
            this.indexedProperties.put(Objects.requireNonNull(k, "indexedProperties key"), Objects.requireNonNull(v, "indexedProperties value"));
            return this;
        }

        public final Builder indexedProperties(Map<? extends NodeLabel, ? extends IndexPropertyMappings.IndexedPropertyMappings> entries) {
            this.indexedProperties = new LinkedHashMap<NodeLabel, IndexPropertyMappings.IndexedPropertyMappings>();
            return this.putAllIndexedProperties(entries);
        }

        public final Builder putAllIndexedProperties(Map<? extends NodeLabel, ? extends IndexPropertyMappings.IndexedPropertyMappings> entries) {
            if (this.indexedProperties == null) {
                this.indexedProperties = new LinkedHashMap<NodeLabel, IndexPropertyMappings.IndexedPropertyMappings>();
            }
            for (Map.Entry<? extends NodeLabel, ? extends IndexPropertyMappings.IndexedPropertyMappings> e : entries.entrySet()) {
                NodeLabel k = e.getKey();
                IndexPropertyMappings.IndexedPropertyMappings v = e.getValue();
                this.indexedProperties.put(Objects.requireNonNull(k, "indexedProperties key"), Objects.requireNonNull(v, "indexedProperties value"));
            }
            return this;
        }

        public Builder clear() {
            if (this.storedProperties != null) {
                this.storedProperties.clear();
            }
            if (this.indexedProperties != null) {
                this.indexedProperties.clear();
            }
            return this;
        }

        public IndexPropertyMappings.LoadablePropertyMappings build() {
            return new ImmutableLoadablePropertyMappings(null, this.storedProperties == null ? Collections.emptyMap() : ImmutableLoadablePropertyMappings.createUnmodifiableMap(false, false, this.storedProperties), this.indexedProperties == null ? Collections.emptyMap() : ImmutableLoadablePropertyMappings.createUnmodifiableMap(false, false, this.indexedProperties));
        }
    }
}

