/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.loading;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.neo4j.gds.core.loading.IndexPropertyMappings;

@ParametersAreNonnullByDefault
@Generated(from="IndexPropertyMappings.IndexedPropertyMappings", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableIndexedPropertyMappings
implements IndexPropertyMappings.IndexedPropertyMappings {
    private final List<IndexPropertyMappings.IndexedPropertyMapping> mappings;

    private ImmutableIndexedPropertyMappings(Iterable<? extends IndexPropertyMappings.IndexedPropertyMapping> mappings) {
        this.mappings = ImmutableIndexedPropertyMappings.createUnmodifiableList(false, ImmutableIndexedPropertyMappings.createSafeList(mappings, true, false));
    }

    private ImmutableIndexedPropertyMappings(ImmutableIndexedPropertyMappings original, List<IndexPropertyMappings.IndexedPropertyMapping> mappings) {
        this.mappings = mappings;
    }

    @Override
    public List<IndexPropertyMappings.IndexedPropertyMapping> mappings() {
        return this.mappings;
    }

    public final ImmutableIndexedPropertyMappings withMappings(IndexPropertyMappings.IndexedPropertyMapping ... elements) {
        List<IndexPropertyMappings.IndexedPropertyMapping> newValue = ImmutableIndexedPropertyMappings.createUnmodifiableList(false, ImmutableIndexedPropertyMappings.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableIndexedPropertyMappings(this, newValue);
    }

    public final ImmutableIndexedPropertyMappings withMappings(Iterable<? extends IndexPropertyMappings.IndexedPropertyMapping> elements) {
        if (this.mappings == elements) {
            return this;
        }
        List<IndexPropertyMappings.IndexedPropertyMapping> newValue = ImmutableIndexedPropertyMappings.createUnmodifiableList(false, ImmutableIndexedPropertyMappings.createSafeList(elements, true, false));
        return new ImmutableIndexedPropertyMappings(this, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableIndexedPropertyMappings && this.equalTo((ImmutableIndexedPropertyMappings)another);
    }

    private boolean equalTo(ImmutableIndexedPropertyMappings another) {
        return this.mappings.equals(another.mappings);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.mappings.hashCode();
        return h;
    }

    public String toString() {
        return "IndexedPropertyMappings{mappings=" + this.mappings + "}";
    }

    public static IndexPropertyMappings.IndexedPropertyMappings of(List<IndexPropertyMappings.IndexedPropertyMapping> mappings) {
        return ImmutableIndexedPropertyMappings.of(mappings);
    }

    public static IndexPropertyMappings.IndexedPropertyMappings of(Iterable<? extends IndexPropertyMappings.IndexedPropertyMapping> mappings) {
        return new ImmutableIndexedPropertyMappings(mappings);
    }

    static IndexPropertyMappings.IndexedPropertyMappings copyOf(IndexPropertyMappings.IndexedPropertyMappings instance) {
        if (instance instanceof ImmutableIndexedPropertyMappings) {
            return (ImmutableIndexedPropertyMappings)instance;
        }
        return ImmutableIndexedPropertyMappings.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="IndexPropertyMappings.IndexedPropertyMappings", generator="Immutables")
    @NotThreadSafe
    static final class Builder {
        private List<IndexPropertyMappings.IndexedPropertyMapping> mappings = null;

        private Builder() {
        }

        public final Builder from(ImmutableIndexedPropertyMappings instance) {
            return this.from((IndexPropertyMappings.IndexedPropertyMappings)instance);
        }

        final Builder from(IndexPropertyMappings.IndexedPropertyMappings instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllMappings(instance.mappings());
            return this;
        }

        public final Builder addMapping(IndexPropertyMappings.IndexedPropertyMapping element) {
            if (this.mappings == null) {
                this.mappings = new ArrayList<IndexPropertyMappings.IndexedPropertyMapping>();
            }
            this.mappings.add(Objects.requireNonNull(element, "mappings element"));
            return this;
        }

        public final Builder addMappings(IndexPropertyMappings.IndexedPropertyMapping ... elements) {
            if (this.mappings == null) {
                this.mappings = new ArrayList<IndexPropertyMappings.IndexedPropertyMapping>();
            }
            for (IndexPropertyMappings.IndexedPropertyMapping element : elements) {
                this.mappings.add(Objects.requireNonNull(element, "mappings element"));
            }
            return this;
        }

        public final Builder mappings(Iterable<? extends IndexPropertyMappings.IndexedPropertyMapping> elements) {
            this.mappings = new ArrayList<IndexPropertyMappings.IndexedPropertyMapping>();
            return this.addAllMappings(elements);
        }

        public final Builder addAllMappings(Iterable<? extends IndexPropertyMappings.IndexedPropertyMapping> elements) {
            Objects.requireNonNull(elements, "mappings element");
            if (this.mappings == null) {
                this.mappings = new ArrayList<IndexPropertyMappings.IndexedPropertyMapping>();
            }
            for (IndexPropertyMappings.IndexedPropertyMapping indexedPropertyMapping : elements) {
                this.mappings.add(Objects.requireNonNull(indexedPropertyMapping, "mappings element"));
            }
            return this;
        }

        public Builder clear() {
            if (this.mappings != null) {
                this.mappings.clear();
            }
            return this;
        }

        public IndexPropertyMappings.IndexedPropertyMappings build() {
            return new ImmutableIndexedPropertyMappings(null, this.mappings == null ? Collections.emptyList() : ImmutableIndexedPropertyMappings.createUnmodifiableList(true, this.mappings));
        }
    }
}

