/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.loading;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.neo4j.gds.PropertyMapping;
import org.neo4j.gds.core.loading.IndexPropertyMappings;
import org.neo4j.internal.schema.IndexDescriptor;

@ParametersAreNonnullByDefault
@Generated(from="IndexPropertyMappings.IndexedPropertyMapping", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableIndexedPropertyMapping
implements IndexPropertyMappings.IndexedPropertyMapping {
    private final PropertyMapping property;
    private final IndexDescriptor index;

    private ImmutableIndexedPropertyMapping(PropertyMapping property, IndexDescriptor index) {
        this.property = Objects.requireNonNull(property, "property");
        this.index = Objects.requireNonNull(index, "index");
    }

    private ImmutableIndexedPropertyMapping(ImmutableIndexedPropertyMapping original, PropertyMapping property, IndexDescriptor index) {
        this.property = property;
        this.index = index;
    }

    @Override
    public PropertyMapping property() {
        return this.property;
    }

    @Override
    public IndexDescriptor index() {
        return this.index;
    }

    public final ImmutableIndexedPropertyMapping withProperty(PropertyMapping value) {
        if (this.property == value) {
            return this;
        }
        PropertyMapping newValue = Objects.requireNonNull(value, "property");
        return new ImmutableIndexedPropertyMapping(this, newValue, this.index);
    }

    public final ImmutableIndexedPropertyMapping withIndex(IndexDescriptor value) {
        if (this.index == value) {
            return this;
        }
        IndexDescriptor newValue = Objects.requireNonNull(value, "index");
        return new ImmutableIndexedPropertyMapping(this, this.property, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableIndexedPropertyMapping && this.equalTo((ImmutableIndexedPropertyMapping)another);
    }

    private boolean equalTo(ImmutableIndexedPropertyMapping another) {
        return this.property.equals(another.property) && this.index.equals((Object)another.index);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.property.hashCode();
        h += (h << 5) + this.index.hashCode();
        return h;
    }

    public String toString() {
        return "IndexedPropertyMapping{property=" + this.property + ", index=" + this.index + "}";
    }

    public static IndexPropertyMappings.IndexedPropertyMapping of(PropertyMapping property, IndexDescriptor index) {
        return new ImmutableIndexedPropertyMapping(property, index);
    }

    static IndexPropertyMappings.IndexedPropertyMapping copyOf(IndexPropertyMappings.IndexedPropertyMapping instance) {
        if (instance instanceof ImmutableIndexedPropertyMapping) {
            return (ImmutableIndexedPropertyMapping)instance;
        }
        return ImmutableIndexedPropertyMapping.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="IndexPropertyMappings.IndexedPropertyMapping", generator="Immutables")
    @NotThreadSafe
    static final class Builder {
        private static final long INIT_BIT_PROPERTY = 1L;
        private static final long INIT_BIT_INDEX = 2L;
        private long initBits = 3L;
        @Nullable
        private PropertyMapping property;
        @Nullable
        private IndexDescriptor index;

        private Builder() {
        }

        public final Builder from(ImmutableIndexedPropertyMapping instance) {
            return this.from((IndexPropertyMappings.IndexedPropertyMapping)instance);
        }

        final Builder from(IndexPropertyMappings.IndexedPropertyMapping instance) {
            Objects.requireNonNull(instance, "instance");
            this.property(instance.property());
            this.index(instance.index());
            return this;
        }

        public final Builder property(PropertyMapping property) {
            this.property = Objects.requireNonNull(property, "property");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder index(IndexDescriptor index) {
            this.index = Objects.requireNonNull(index, "index");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public Builder clear() {
            this.initBits = 3L;
            this.property = null;
            this.index = null;
            return this;
        }

        public IndexPropertyMappings.IndexedPropertyMapping build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableIndexedPropertyMapping(null, this.property, this.index);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("property");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("index");
            }
            return "Cannot build IndexedPropertyMapping, some of required attributes are not set " + attributes;
        }
    }
}

