/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.loading;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.neo4j.gds.core.loading.RecordScannerTaskRunner;

@ParametersAreNonnullByDefault
@Generated(from="RecordScannerTaskRunner.ImportResult", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableImportResult
implements RecordScannerTaskRunner.ImportResult {
    private final long durationNanos;
    private final long importedRecords;
    private final long importedProperties;

    private ImmutableImportResult(long durationNanos, long importedRecords, long importedProperties) {
        this.durationNanos = durationNanos;
        this.importedRecords = importedRecords;
        this.importedProperties = importedProperties;
    }

    @Override
    public long durationNanos() {
        return this.durationNanos;
    }

    @Override
    public long importedRecords() {
        return this.importedRecords;
    }

    @Override
    public long importedProperties() {
        return this.importedProperties;
    }

    public final ImmutableImportResult withDurationNanos(long value) {
        if (this.durationNanos == value) {
            return this;
        }
        return new ImmutableImportResult(value, this.importedRecords, this.importedProperties);
    }

    public final ImmutableImportResult withImportedRecords(long value) {
        if (this.importedRecords == value) {
            return this;
        }
        return new ImmutableImportResult(this.durationNanos, value, this.importedProperties);
    }

    public final ImmutableImportResult withImportedProperties(long value) {
        if (this.importedProperties == value) {
            return this;
        }
        return new ImmutableImportResult(this.durationNanos, this.importedRecords, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableImportResult && this.equalTo((ImmutableImportResult)another);
    }

    private boolean equalTo(ImmutableImportResult another) {
        return this.durationNanos == another.durationNanos && this.importedRecords == another.importedRecords && this.importedProperties == another.importedProperties;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Long.hashCode(this.durationNanos);
        h += (h << 5) + Long.hashCode(this.importedRecords);
        h += (h << 5) + Long.hashCode(this.importedProperties);
        return h;
    }

    public String toString() {
        return "ImportResult{durationNanos=" + this.durationNanos + ", importedRecords=" + this.importedRecords + ", importedProperties=" + this.importedProperties + "}";
    }

    public static RecordScannerTaskRunner.ImportResult of(long durationNanos, long importedRecords, long importedProperties) {
        return new ImmutableImportResult(durationNanos, importedRecords, importedProperties);
    }

    static RecordScannerTaskRunner.ImportResult copyOf(RecordScannerTaskRunner.ImportResult instance) {
        if (instance instanceof ImmutableImportResult) {
            return (ImmutableImportResult)instance;
        }
        return ImmutableImportResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="RecordScannerTaskRunner.ImportResult", generator="Immutables")
    @NotThreadSafe
    static final class Builder {
        private static final long INIT_BIT_DURATION_NANOS = 1L;
        private static final long INIT_BIT_IMPORTED_RECORDS = 2L;
        private static final long INIT_BIT_IMPORTED_PROPERTIES = 4L;
        private long initBits = 7L;
        private long durationNanos;
        private long importedRecords;
        private long importedProperties;

        private Builder() {
        }

        public final Builder from(ImmutableImportResult instance) {
            return this.from((RecordScannerTaskRunner.ImportResult)instance);
        }

        final Builder from(RecordScannerTaskRunner.ImportResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.durationNanos(instance.durationNanos());
            this.importedRecords(instance.importedRecords());
            this.importedProperties(instance.importedProperties());
            return this;
        }

        public final Builder durationNanos(long durationNanos) {
            this.durationNanos = durationNanos;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder importedRecords(long importedRecords) {
            this.importedRecords = importedRecords;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder importedProperties(long importedProperties) {
            this.importedProperties = importedProperties;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public Builder clear() {
            this.initBits = 7L;
            this.durationNanos = 0L;
            this.importedRecords = 0L;
            this.importedProperties = 0L;
            return this;
        }

        public RecordScannerTaskRunner.ImportResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableImportResult(this.durationNanos, this.importedRecords, this.importedProperties);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("durationNanos");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("importedRecords");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("importedProperties");
            }
            return "Cannot build ImportResult, some of required attributes are not set " + attributes;
        }
    }
}

