/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.loading;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.neo4j.gds.RelationshipProjection;
import org.neo4j.gds.core.Aggregation;
import org.neo4j.gds.core.loading.SingleTypeRelationshipImporter;

@ParametersAreNonnullByDefault
@Generated(from="SingleTypeRelationshipImporter.ImportMetaData", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableImportMetaData
implements SingleTypeRelationshipImporter.ImportMetaData {
    private final RelationshipProjection projection;
    private final Aggregation[] aggregations;
    private final int[] propertyKeyIds;
    private final double[] defaultValues;
    private final int typeTokenId;

    private ImmutableImportMetaData(RelationshipProjection projection, Aggregation[] aggregations, int[] propertyKeyIds, double[] defaultValues, int typeTokenId) {
        this.projection = Objects.requireNonNull(projection, "projection");
        this.aggregations = (Aggregation[])aggregations.clone();
        this.propertyKeyIds = (int[])propertyKeyIds.clone();
        this.defaultValues = (double[])defaultValues.clone();
        this.typeTokenId = typeTokenId;
    }

    private ImmutableImportMetaData(ImmutableImportMetaData original, RelationshipProjection projection, Aggregation[] aggregations, int[] propertyKeyIds, double[] defaultValues, int typeTokenId) {
        this.projection = projection;
        this.aggregations = aggregations;
        this.propertyKeyIds = propertyKeyIds;
        this.defaultValues = defaultValues;
        this.typeTokenId = typeTokenId;
    }

    @Override
    public RelationshipProjection projection() {
        return this.projection;
    }

    @Override
    public Aggregation[] aggregations() {
        return (Aggregation[])this.aggregations.clone();
    }

    @Override
    public int[] propertyKeyIds() {
        return (int[])this.propertyKeyIds.clone();
    }

    @Override
    public double[] defaultValues() {
        return (double[])this.defaultValues.clone();
    }

    @Override
    public int typeTokenId() {
        return this.typeTokenId;
    }

    public final ImmutableImportMetaData withProjection(RelationshipProjection value) {
        if (this.projection == value) {
            return this;
        }
        RelationshipProjection newValue = Objects.requireNonNull(value, "projection");
        return new ImmutableImportMetaData(this, newValue, this.aggregations, this.propertyKeyIds, this.defaultValues, this.typeTokenId);
    }

    public final ImmutableImportMetaData withAggregations(Aggregation ... elements) {
        Aggregation[] newValue = (Aggregation[])elements.clone();
        return new ImmutableImportMetaData(this, this.projection, newValue, this.propertyKeyIds, this.defaultValues, this.typeTokenId);
    }

    public final ImmutableImportMetaData withPropertyKeyIds(int ... elements) {
        int[] newValue = (int[])elements.clone();
        return new ImmutableImportMetaData(this, this.projection, this.aggregations, newValue, this.defaultValues, this.typeTokenId);
    }

    public final ImmutableImportMetaData withDefaultValues(double ... elements) {
        double[] newValue = (double[])elements.clone();
        return new ImmutableImportMetaData(this, this.projection, this.aggregations, this.propertyKeyIds, newValue, this.typeTokenId);
    }

    public final ImmutableImportMetaData withTypeTokenId(int value) {
        if (this.typeTokenId == value) {
            return this;
        }
        return new ImmutableImportMetaData(this, this.projection, this.aggregations, this.propertyKeyIds, this.defaultValues, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableImportMetaData && this.equalTo((ImmutableImportMetaData)another);
    }

    private boolean equalTo(ImmutableImportMetaData another) {
        return this.projection.equals((Object)another.projection) && Arrays.equals(this.aggregations, another.aggregations) && Arrays.equals(this.propertyKeyIds, another.propertyKeyIds) && Arrays.equals(this.defaultValues, another.defaultValues) && this.typeTokenId == another.typeTokenId;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.projection.hashCode();
        h += (h << 5) + Arrays.hashCode(this.aggregations);
        h += (h << 5) + Arrays.hashCode(this.propertyKeyIds);
        h += (h << 5) + Arrays.hashCode(this.defaultValues);
        h += (h << 5) + this.typeTokenId;
        return h;
    }

    public String toString() {
        return "ImportMetaData{projection=" + this.projection + ", aggregations=" + Arrays.toString(this.aggregations) + ", propertyKeyIds=" + Arrays.toString(this.propertyKeyIds) + ", defaultValues=" + Arrays.toString(this.defaultValues) + ", typeTokenId=" + this.typeTokenId + "}";
    }

    public static SingleTypeRelationshipImporter.ImportMetaData of(RelationshipProjection projection, Aggregation[] aggregations, int[] propertyKeyIds, double[] defaultValues, int typeTokenId) {
        return new ImmutableImportMetaData(projection, aggregations, propertyKeyIds, defaultValues, typeTokenId);
    }

    public static SingleTypeRelationshipImporter.ImportMetaData copyOf(SingleTypeRelationshipImporter.ImportMetaData instance) {
        if (instance instanceof ImmutableImportMetaData) {
            return (ImmutableImportMetaData)instance;
        }
        return ImmutableImportMetaData.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="SingleTypeRelationshipImporter.ImportMetaData", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_PROJECTION = 1L;
        private static final long INIT_BIT_AGGREGATIONS = 2L;
        private static final long INIT_BIT_PROPERTY_KEY_IDS = 4L;
        private static final long INIT_BIT_DEFAULT_VALUES = 8L;
        private static final long INIT_BIT_TYPE_TOKEN_ID = 16L;
        private long initBits = 31L;
        @Nullable
        private RelationshipProjection projection;
        @Nullable
        private Aggregation[] aggregations;
        @Nullable
        private int[] propertyKeyIds;
        @Nullable
        private double[] defaultValues;
        private int typeTokenId;

        private Builder() {
        }

        public final Builder from(SingleTypeRelationshipImporter.ImportMetaData instance) {
            Objects.requireNonNull(instance, "instance");
            this.projection(instance.projection());
            this.aggregations(instance.aggregations());
            this.propertyKeyIds(instance.propertyKeyIds());
            this.defaultValues(instance.defaultValues());
            this.typeTokenId(instance.typeTokenId());
            return this;
        }

        public final Builder projection(RelationshipProjection projection) {
            this.projection = Objects.requireNonNull(projection, "projection");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder aggregations(Aggregation ... aggregations) {
            this.aggregations = (Aggregation[])aggregations.clone();
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder propertyKeyIds(int ... propertyKeyIds) {
            this.propertyKeyIds = (int[])propertyKeyIds.clone();
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder defaultValues(double ... defaultValues) {
            this.defaultValues = (double[])defaultValues.clone();
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder typeTokenId(int typeTokenId) {
            this.typeTokenId = typeTokenId;
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public Builder clear() {
            this.initBits = 31L;
            this.projection = null;
            this.aggregations = null;
            this.propertyKeyIds = null;
            this.defaultValues = null;
            this.typeTokenId = 0;
            return this;
        }

        public SingleTypeRelationshipImporter.ImportMetaData build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableImportMetaData(null, this.projection, this.aggregations, this.propertyKeyIds, this.defaultValues, this.typeTokenId);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("projection");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("aggregations");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("propertyKeyIds");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("defaultValues");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("typeTokenId");
            }
            return "Cannot build ImportMetaData, some of required attributes are not set " + attributes;
        }
    }
}

