/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.loading;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.neo4j.gds.api.IdMap;
import org.neo4j.gds.api.properties.nodes.NodePropertyStore;
import org.neo4j.gds.core.loading.IdMapAndProperties;

@ParametersAreNonnullByDefault
@Generated(from="IdMapAndProperties", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableIdMapAndProperties
implements IdMapAndProperties {
    private final IdMap idMap;
    private final NodePropertyStore properties;

    private ImmutableIdMapAndProperties(IdMap idMap, NodePropertyStore properties) {
        this.idMap = Objects.requireNonNull(idMap, "idMap");
        this.properties = Objects.requireNonNull(properties, "properties");
    }

    private ImmutableIdMapAndProperties(ImmutableIdMapAndProperties original, IdMap idMap, NodePropertyStore properties) {
        this.idMap = idMap;
        this.properties = properties;
    }

    @Override
    public IdMap idMap() {
        return this.idMap;
    }

    @Override
    public NodePropertyStore properties() {
        return this.properties;
    }

    public final ImmutableIdMapAndProperties withIdMap(IdMap value) {
        if (this.idMap == value) {
            return this;
        }
        IdMap newValue = Objects.requireNonNull(value, "idMap");
        return new ImmutableIdMapAndProperties(this, newValue, this.properties);
    }

    public final ImmutableIdMapAndProperties withProperties(NodePropertyStore value) {
        if (this.properties == value) {
            return this;
        }
        NodePropertyStore newValue = Objects.requireNonNull(value, "properties");
        return new ImmutableIdMapAndProperties(this, this.idMap, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableIdMapAndProperties && this.equalTo((ImmutableIdMapAndProperties)another);
    }

    private boolean equalTo(ImmutableIdMapAndProperties another) {
        return this.idMap.equals(another.idMap) && this.properties.equals(another.properties);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.idMap.hashCode();
        h += (h << 5) + this.properties.hashCode();
        return h;
    }

    public String toString() {
        return "IdMapAndProperties{idMap=" + this.idMap + ", properties=" + this.properties + "}";
    }

    public static IdMapAndProperties of(IdMap idMap, NodePropertyStore properties) {
        return new ImmutableIdMapAndProperties(idMap, properties);
    }

    public static IdMapAndProperties copyOf(IdMapAndProperties instance) {
        if (instance instanceof ImmutableIdMapAndProperties) {
            return (ImmutableIdMapAndProperties)instance;
        }
        return ImmutableIdMapAndProperties.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="IdMapAndProperties", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID_MAP = 1L;
        private static final long INIT_BIT_PROPERTIES = 2L;
        private long initBits = 3L;
        @Nullable
        private IdMap idMap;
        @Nullable
        private NodePropertyStore properties;

        private Builder() {
        }

        public final Builder from(IdMapAndProperties instance) {
            Objects.requireNonNull(instance, "instance");
            this.idMap(instance.idMap());
            this.properties(instance.properties());
            return this;
        }

        public final Builder idMap(IdMap idMap) {
            this.idMap = Objects.requireNonNull(idMap, "idMap");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder properties(NodePropertyStore properties) {
            this.properties = Objects.requireNonNull(properties, "properties");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public Builder clear() {
            this.initBits = 3L;
            this.idMap = null;
            this.properties = null;
            return this;
        }

        public IdMapAndProperties build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableIdMapAndProperties(null, this.idMap, this.properties);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("idMap");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("properties");
            }
            return "Cannot build IdMapAndProperties, some of required attributes are not set " + attributes;
        }
    }
}

