/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.loading;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.config.GraphProjectConfig;
import org.neo4j.gds.core.loading.GraphStoreCatalog;

@ParametersAreNonnullByDefault
@Generated(from="GraphStoreCatalog.GraphStoreWithUserNameAndConfig", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableGraphStoreWithUserNameAndConfig
implements GraphStoreCatalog.GraphStoreWithUserNameAndConfig {
    private final GraphStore graphStore;
    private final String userName;
    private final GraphProjectConfig config;

    private ImmutableGraphStoreWithUserNameAndConfig(GraphStore graphStore, String userName, GraphProjectConfig config) {
        this.graphStore = Objects.requireNonNull(graphStore, "graphStore");
        this.userName = Objects.requireNonNull(userName, "userName");
        this.config = Objects.requireNonNull(config, "config");
    }

    private ImmutableGraphStoreWithUserNameAndConfig(ImmutableGraphStoreWithUserNameAndConfig original, GraphStore graphStore, String userName, GraphProjectConfig config) {
        this.graphStore = graphStore;
        this.userName = userName;
        this.config = config;
    }

    @Override
    public GraphStore graphStore() {
        return this.graphStore;
    }

    @Override
    public String userName() {
        return this.userName;
    }

    @Override
    public GraphProjectConfig config() {
        return this.config;
    }

    public final ImmutableGraphStoreWithUserNameAndConfig withGraphStore(GraphStore value) {
        if (this.graphStore == value) {
            return this;
        }
        GraphStore newValue = Objects.requireNonNull(value, "graphStore");
        return new ImmutableGraphStoreWithUserNameAndConfig(this, newValue, this.userName, this.config);
    }

    public final ImmutableGraphStoreWithUserNameAndConfig withUserName(String value) {
        String newValue = Objects.requireNonNull(value, "userName");
        if (this.userName.equals(newValue)) {
            return this;
        }
        return new ImmutableGraphStoreWithUserNameAndConfig(this, this.graphStore, newValue, this.config);
    }

    public final ImmutableGraphStoreWithUserNameAndConfig withConfig(GraphProjectConfig value) {
        if (this.config == value) {
            return this;
        }
        GraphProjectConfig newValue = Objects.requireNonNull(value, "config");
        return new ImmutableGraphStoreWithUserNameAndConfig(this, this.graphStore, this.userName, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGraphStoreWithUserNameAndConfig && this.equalTo((ImmutableGraphStoreWithUserNameAndConfig)another);
    }

    private boolean equalTo(ImmutableGraphStoreWithUserNameAndConfig another) {
        return this.graphStore.equals(another.graphStore) && this.userName.equals(another.userName) && this.config.equals(another.config);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.graphStore.hashCode();
        h += (h << 5) + this.userName.hashCode();
        h += (h << 5) + this.config.hashCode();
        return h;
    }

    public String toString() {
        return "GraphStoreWithUserNameAndConfig{graphStore=" + this.graphStore + ", userName=" + this.userName + ", config=" + this.config + "}";
    }

    public static GraphStoreCatalog.GraphStoreWithUserNameAndConfig of(GraphStore graphStore, String userName, GraphProjectConfig config) {
        return new ImmutableGraphStoreWithUserNameAndConfig(graphStore, userName, config);
    }

    public static GraphStoreCatalog.GraphStoreWithUserNameAndConfig copyOf(GraphStoreCatalog.GraphStoreWithUserNameAndConfig instance) {
        if (instance instanceof ImmutableGraphStoreWithUserNameAndConfig) {
            return (ImmutableGraphStoreWithUserNameAndConfig)instance;
        }
        return ImmutableGraphStoreWithUserNameAndConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="GraphStoreCatalog.GraphStoreWithUserNameAndConfig", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_GRAPH_STORE = 1L;
        private static final long INIT_BIT_USER_NAME = 2L;
        private static final long INIT_BIT_CONFIG = 4L;
        private long initBits = 7L;
        @Nullable
        private GraphStore graphStore;
        @Nullable
        private String userName;
        @Nullable
        private GraphProjectConfig config;

        private Builder() {
        }

        public final Builder from(GraphStoreCatalog.GraphStoreWithUserNameAndConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.graphStore(instance.graphStore());
            this.userName(instance.userName());
            this.config(instance.config());
            return this;
        }

        public final Builder graphStore(GraphStore graphStore) {
            this.graphStore = Objects.requireNonNull(graphStore, "graphStore");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder userName(String userName) {
            this.userName = Objects.requireNonNull(userName, "userName");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder config(GraphProjectConfig config) {
            this.config = Objects.requireNonNull(config, "config");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public Builder clear() {
            this.initBits = 7L;
            this.graphStore = null;
            this.userName = null;
            this.config = null;
            return this;
        }

        public GraphStoreCatalog.GraphStoreWithUserNameAndConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGraphStoreWithUserNameAndConfig(null, this.graphStore, this.userName, this.config);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("graphStore");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("userName");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("config");
            }
            return "Cannot build GraphStoreWithUserNameAndConfig, some of required attributes are not set " + attributes;
        }
    }
}

