/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.loading;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.config.GraphProjectConfig;
import org.neo4j.gds.core.loading.GraphStoreWithConfig;

@ParametersAreNonnullByDefault
@Generated(from="GraphStoreWithConfig", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableGraphStoreWithConfig
implements GraphStoreWithConfig {
    private final GraphStore graphStore;
    private final GraphProjectConfig config;

    private ImmutableGraphStoreWithConfig(GraphStore graphStore, GraphProjectConfig config) {
        this.graphStore = Objects.requireNonNull(graphStore, "graphStore");
        this.config = Objects.requireNonNull(config, "config");
    }

    private ImmutableGraphStoreWithConfig(ImmutableGraphStoreWithConfig original, GraphStore graphStore, GraphProjectConfig config) {
        this.graphStore = graphStore;
        this.config = config;
    }

    @Override
    public GraphStore graphStore() {
        return this.graphStore;
    }

    @Override
    public GraphProjectConfig config() {
        return this.config;
    }

    public final ImmutableGraphStoreWithConfig withGraphStore(GraphStore value) {
        if (this.graphStore == value) {
            return this;
        }
        GraphStore newValue = Objects.requireNonNull(value, "graphStore");
        return new ImmutableGraphStoreWithConfig(this, newValue, this.config);
    }

    public final ImmutableGraphStoreWithConfig withConfig(GraphProjectConfig value) {
        if (this.config == value) {
            return this;
        }
        GraphProjectConfig newValue = Objects.requireNonNull(value, "config");
        return new ImmutableGraphStoreWithConfig(this, this.graphStore, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGraphStoreWithConfig && this.equalTo((ImmutableGraphStoreWithConfig)another);
    }

    private boolean equalTo(ImmutableGraphStoreWithConfig another) {
        return this.graphStore.equals(another.graphStore) && this.config.equals(another.config);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.graphStore.hashCode();
        h += (h << 5) + this.config.hashCode();
        return h;
    }

    public String toString() {
        return "GraphStoreWithConfig{graphStore=" + this.graphStore + ", config=" + this.config + "}";
    }

    public static GraphStoreWithConfig of(GraphStore graphStore, GraphProjectConfig config) {
        return new ImmutableGraphStoreWithConfig(graphStore, config);
    }

    public static GraphStoreWithConfig copyOf(GraphStoreWithConfig instance) {
        if (instance instanceof ImmutableGraphStoreWithConfig) {
            return (ImmutableGraphStoreWithConfig)instance;
        }
        return ImmutableGraphStoreWithConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="GraphStoreWithConfig", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_GRAPH_STORE = 1L;
        private static final long INIT_BIT_CONFIG = 2L;
        private long initBits = 3L;
        @Nullable
        private GraphStore graphStore;
        @Nullable
        private GraphProjectConfig config;

        private Builder() {
        }

        public final Builder from(GraphStoreWithConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.graphStore(instance.graphStore());
            this.config(instance.config());
            return this;
        }

        public final Builder graphStore(GraphStore graphStore) {
            this.graphStore = Objects.requireNonNull(graphStore, "graphStore");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder config(GraphProjectConfig config) {
            this.config = Objects.requireNonNull(config, "config");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public Builder clear() {
            this.initBits = 3L;
            this.graphStore = null;
            this.config = null;
            return this;
        }

        public GraphStoreWithConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGraphStoreWithConfig(null, this.graphStore, this.config);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("graphStore");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("config");
            }
            return "Cannot build GraphStoreWithConfig, some of required attributes are not set " + attributes;
        }
    }
}

