/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.loading;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.neo4j.gds.PropertyMapping;
import org.neo4j.gds.core.loading.CypherFactory;

@ParametersAreNonnullByDefault
@Generated(from="CypherFactory.EstimationResult", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableEstimationResult
implements CypherFactory.EstimationResult {
    private final long estimatedRows;
    private final long propertyCount;
    private final transient Map<String, Integer> propertyTokens;
    private final transient Collection<PropertyMapping> propertyMappings;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableEstimationResult(long estimatedRows, long propertyCount) {
        this.estimatedRows = estimatedRows;
        this.propertyCount = propertyCount;
        this.propertyTokens = this.initShim.propertyTokens();
        this.propertyMappings = this.initShim.propertyMappings();
        this.initShim = null;
    }

    private Map<String, Integer> propertyTokensInitialize() {
        return CypherFactory.EstimationResult.super.propertyTokens();
    }

    private Collection<PropertyMapping> propertyMappingsInitialize() {
        return CypherFactory.EstimationResult.super.propertyMappings();
    }

    @Override
    public long estimatedRows() {
        return this.estimatedRows;
    }

    @Override
    public long propertyCount() {
        return this.propertyCount;
    }

    @Override
    public Map<String, Integer> propertyTokens() {
        InitShim shim = this.initShim;
        return shim != null ? shim.propertyTokens() : this.propertyTokens;
    }

    @Override
    public Collection<PropertyMapping> propertyMappings() {
        InitShim shim = this.initShim;
        return shim != null ? shim.propertyMappings() : this.propertyMappings;
    }

    public final ImmutableEstimationResult withEstimatedRows(long value) {
        if (this.estimatedRows == value) {
            return this;
        }
        return new ImmutableEstimationResult(value, this.propertyCount);
    }

    public final ImmutableEstimationResult withPropertyCount(long value) {
        if (this.propertyCount == value) {
            return this;
        }
        return new ImmutableEstimationResult(this.estimatedRows, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableEstimationResult && this.equalTo((ImmutableEstimationResult)another);
    }

    private boolean equalTo(ImmutableEstimationResult another) {
        return this.estimatedRows == another.estimatedRows && this.propertyCount == another.propertyCount && this.propertyTokens.equals(another.propertyTokens) && this.propertyMappings.equals(another.propertyMappings);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Long.hashCode(this.estimatedRows);
        h += (h << 5) + Long.hashCode(this.propertyCount);
        h += (h << 5) + this.propertyTokens.hashCode();
        h += (h << 5) + this.propertyMappings.hashCode();
        return h;
    }

    public String toString() {
        return "EstimationResult{estimatedRows=" + this.estimatedRows + ", propertyCount=" + this.propertyCount + ", propertyTokens=" + this.propertyTokens + ", propertyMappings=" + this.propertyMappings + "}";
    }

    public static CypherFactory.EstimationResult of(long estimatedRows, long propertyCount) {
        return new ImmutableEstimationResult(estimatedRows, propertyCount);
    }

    static CypherFactory.EstimationResult copyOf(CypherFactory.EstimationResult instance) {
        if (instance instanceof ImmutableEstimationResult) {
            return (ImmutableEstimationResult)instance;
        }
        return ImmutableEstimationResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="CypherFactory.EstimationResult", generator="Immutables")
    @NotThreadSafe
    static final class Builder {
        private static final long INIT_BIT_ESTIMATED_ROWS = 1L;
        private static final long INIT_BIT_PROPERTY_COUNT = 2L;
        private long initBits = 3L;
        private long estimatedRows;
        private long propertyCount;

        private Builder() {
        }

        public final Builder from(ImmutableEstimationResult instance) {
            return this.from((CypherFactory.EstimationResult)instance);
        }

        final Builder from(CypherFactory.EstimationResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.estimatedRows(instance.estimatedRows());
            this.propertyCount(instance.propertyCount());
            return this;
        }

        public final Builder estimatedRows(long estimatedRows) {
            this.estimatedRows = estimatedRows;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder propertyCount(long propertyCount) {
            this.propertyCount = propertyCount;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public Builder clear() {
            this.initBits = 3L;
            this.estimatedRows = 0L;
            this.propertyCount = 0L;
            return this;
        }

        public CypherFactory.EstimationResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableEstimationResult(this.estimatedRows, this.propertyCount);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("estimatedRows");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("propertyCount");
            }
            return "Cannot build EstimationResult, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="CypherFactory.EstimationResult", generator="Immutables")
    private final class InitShim {
        private byte propertyTokensBuildStage = 0;
        private Map<String, Integer> propertyTokens;
        private byte propertyMappingsBuildStage = 0;
        private Collection<PropertyMapping> propertyMappings;

        private InitShim() {
        }

        Map<String, Integer> propertyTokens() {
            if (this.propertyTokensBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.propertyTokensBuildStage == 0) {
                this.propertyTokensBuildStage = (byte)-1;
                this.propertyTokens = Objects.requireNonNull(ImmutableEstimationResult.this.propertyTokensInitialize(), "propertyTokens");
                this.propertyTokensBuildStage = 1;
            }
            return this.propertyTokens;
        }

        Collection<PropertyMapping> propertyMappings() {
            if (this.propertyMappingsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.propertyMappingsBuildStage == 0) {
                this.propertyMappingsBuildStage = (byte)-1;
                this.propertyMappings = Objects.requireNonNull(ImmutableEstimationResult.this.propertyMappingsInitialize(), "propertyMappings");
                this.propertyMappingsBuildStage = 1;
            }
            return this.propertyMappings;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.propertyTokensBuildStage == -1) {
                attributes.add("propertyTokens");
            }
            if (this.propertyMappingsBuildStage == -1) {
                attributes.add("propertyMappings");
            }
            return "Cannot build EstimationResult, attribute initializers form cycle " + attributes;
        }
    }
}

