/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.loading;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.neo4j.gds.core.loading.DeletionResult;

@ParametersAreNonnullByDefault
@Generated(from="DeletionResult", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableDeletionResult
implements DeletionResult {
    private final long deletedRelationships;
    private final Map<String, Long> deletedProperties;

    private ImmutableDeletionResult(long deletedRelationships, Map<String, ? extends Long> deletedProperties) {
        this.deletedRelationships = deletedRelationships;
        this.deletedProperties = ImmutableDeletionResult.createUnmodifiableMap(true, false, deletedProperties);
    }

    private ImmutableDeletionResult(ImmutableDeletionResult original, long deletedRelationships, Map<String, Long> deletedProperties) {
        this.deletedRelationships = deletedRelationships;
        this.deletedProperties = deletedProperties;
    }

    @Override
    public long deletedRelationships() {
        return this.deletedRelationships;
    }

    @Override
    public Map<String, Long> deletedProperties() {
        return this.deletedProperties;
    }

    public final ImmutableDeletionResult withDeletedRelationships(long value) {
        if (this.deletedRelationships == value) {
            return this;
        }
        return new ImmutableDeletionResult(this, value, this.deletedProperties);
    }

    public final ImmutableDeletionResult withDeletedProperties(Map<String, ? extends Long> entries) {
        if (this.deletedProperties == entries) {
            return this;
        }
        Map<String, Long> newValue = ImmutableDeletionResult.createUnmodifiableMap(true, false, entries);
        return new ImmutableDeletionResult(this, this.deletedRelationships, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDeletionResult && this.equalTo((ImmutableDeletionResult)another);
    }

    private boolean equalTo(ImmutableDeletionResult another) {
        return this.deletedRelationships == another.deletedRelationships && this.deletedProperties.equals(another.deletedProperties);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Long.hashCode(this.deletedRelationships);
        h += (h << 5) + this.deletedProperties.hashCode();
        return h;
    }

    public String toString() {
        return "DeletionResult{deletedRelationships=" + this.deletedRelationships + ", deletedProperties=" + this.deletedProperties + "}";
    }

    public static DeletionResult of(long deletedRelationships, Map<String, ? extends Long> deletedProperties) {
        return new ImmutableDeletionResult(deletedRelationships, deletedProperties);
    }

    public static DeletionResult copyOf(DeletionResult instance) {
        if (instance instanceof ImmutableDeletionResult) {
            return (ImmutableDeletionResult)instance;
        }
        return ImmutableDeletionResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="DeletionResult", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_DELETED_RELATIONSHIPS = 1L;
        private long initBits = 1L;
        private long deletedRelationships;
        private Map<String, Long> deletedProperties = null;

        private Builder() {
        }

        public final Builder from(DeletionResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.deletedRelationships(instance.deletedRelationships());
            this.putAllDeletedProperties(instance.deletedProperties());
            return this;
        }

        public final Builder deletedRelationships(long deletedRelationships) {
            this.deletedRelationships = deletedRelationships;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder putDeletedProperty(String key, long value) {
            if (this.deletedProperties == null) {
                this.deletedProperties = new LinkedHashMap<String, Long>();
            }
            this.deletedProperties.put(Objects.requireNonNull(key, "deletedProperties key"), Objects.requireNonNull(Long.valueOf(value), "deletedProperties value"));
            return this;
        }

        public final Builder putDeletedProperty(Map.Entry<String, ? extends Long> entry) {
            if (this.deletedProperties == null) {
                this.deletedProperties = new LinkedHashMap<String, Long>();
            }
            String k = entry.getKey();
            Long v = entry.getValue();
            this.deletedProperties.put(Objects.requireNonNull(k, "deletedProperties key"), Objects.requireNonNull(v, "deletedProperties value"));
            return this;
        }

        public final Builder deletedProperties(Map<String, ? extends Long> entries) {
            this.deletedProperties = new LinkedHashMap<String, Long>();
            return this.putAllDeletedProperties(entries);
        }

        public final Builder putAllDeletedProperties(Map<String, ? extends Long> entries) {
            if (this.deletedProperties == null) {
                this.deletedProperties = new LinkedHashMap<String, Long>();
            }
            for (Map.Entry<String, ? extends Long> e : entries.entrySet()) {
                String k = e.getKey();
                Long v = e.getValue();
                this.deletedProperties.put(Objects.requireNonNull(k, "deletedProperties key"), Objects.requireNonNull(v, "deletedProperties value"));
            }
            return this;
        }

        public Builder clear() {
            this.initBits = 1L;
            this.deletedRelationships = 0L;
            if (this.deletedProperties != null) {
                this.deletedProperties.clear();
            }
            return this;
        }

        public DeletionResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDeletionResult(null, this.deletedRelationships, this.deletedProperties == null ? Collections.emptyMap() : ImmutableDeletionResult.createUnmodifiableMap(false, false, this.deletedProperties));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("deletedRelationships");
            }
            return "Cannot build DeletionResult, some of required attributes are not set " + attributes;
        }
    }
}

