/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.loading;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.neo4j.gds.core.loading.DoubleCodec;

@ParametersAreNonnullByDefault
@Generated(from="DoubleCodec.CompressionInfo", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableCompressionInfo
implements DoubleCodec.CompressionInfo {
    private final double input;
    private final byte[] compressed;
    private final double decompressed;
    private final int compressedSize;
    private final int compressedType;
    private final String compressionDescription;

    private ImmutableCompressionInfo(double input, byte[] compressed, double decompressed, int compressedSize, int compressedType, String compressionDescription) {
        this.input = input;
        this.compressed = (byte[])compressed.clone();
        this.decompressed = decompressed;
        this.compressedSize = compressedSize;
        this.compressedType = compressedType;
        this.compressionDescription = Objects.requireNonNull(compressionDescription, "compressionDescription");
    }

    private ImmutableCompressionInfo(ImmutableCompressionInfo original, double input, byte[] compressed, double decompressed, int compressedSize, int compressedType, String compressionDescription) {
        this.input = input;
        this.compressed = compressed;
        this.decompressed = decompressed;
        this.compressedSize = compressedSize;
        this.compressedType = compressedType;
        this.compressionDescription = compressionDescription;
    }

    @Override
    public double input() {
        return this.input;
    }

    @Override
    public byte[] compressed() {
        return (byte[])this.compressed.clone();
    }

    @Override
    public double decompressed() {
        return this.decompressed;
    }

    @Override
    public int compressedSize() {
        return this.compressedSize;
    }

    @Override
    public int compressedType() {
        return this.compressedType;
    }

    @Override
    public String compressionDescription() {
        return this.compressionDescription;
    }

    public final ImmutableCompressionInfo withInput(double value) {
        if (Double.doubleToLongBits(this.input) == Double.doubleToLongBits(value)) {
            return this;
        }
        return new ImmutableCompressionInfo(this, value, this.compressed, this.decompressed, this.compressedSize, this.compressedType, this.compressionDescription);
    }

    public final ImmutableCompressionInfo withCompressed(byte ... elements) {
        byte[] newValue = (byte[])elements.clone();
        return new ImmutableCompressionInfo(this, this.input, newValue, this.decompressed, this.compressedSize, this.compressedType, this.compressionDescription);
    }

    public final ImmutableCompressionInfo withDecompressed(double value) {
        if (Double.doubleToLongBits(this.decompressed) == Double.doubleToLongBits(value)) {
            return this;
        }
        return new ImmutableCompressionInfo(this, this.input, this.compressed, value, this.compressedSize, this.compressedType, this.compressionDescription);
    }

    public final ImmutableCompressionInfo withCompressedSize(int value) {
        if (this.compressedSize == value) {
            return this;
        }
        return new ImmutableCompressionInfo(this, this.input, this.compressed, this.decompressed, value, this.compressedType, this.compressionDescription);
    }

    public final ImmutableCompressionInfo withCompressedType(int value) {
        if (this.compressedType == value) {
            return this;
        }
        return new ImmutableCompressionInfo(this, this.input, this.compressed, this.decompressed, this.compressedSize, value, this.compressionDescription);
    }

    public final ImmutableCompressionInfo withCompressionDescription(String value) {
        String newValue = Objects.requireNonNull(value, "compressionDescription");
        if (this.compressionDescription.equals(newValue)) {
            return this;
        }
        return new ImmutableCompressionInfo(this, this.input, this.compressed, this.decompressed, this.compressedSize, this.compressedType, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCompressionInfo && this.equalTo((ImmutableCompressionInfo)another);
    }

    private boolean equalTo(ImmutableCompressionInfo another) {
        return Double.doubleToLongBits(this.input) == Double.doubleToLongBits(another.input) && Arrays.equals(this.compressed, another.compressed) && Double.doubleToLongBits(this.decompressed) == Double.doubleToLongBits(another.decompressed) && this.compressedSize == another.compressedSize && this.compressedType == another.compressedType && this.compressionDescription.equals(another.compressionDescription);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Double.hashCode(this.input);
        h += (h << 5) + Arrays.hashCode(this.compressed);
        h += (h << 5) + Double.hashCode(this.decompressed);
        h += (h << 5) + this.compressedSize;
        h += (h << 5) + this.compressedType;
        h += (h << 5) + this.compressionDescription.hashCode();
        return h;
    }

    public String toString() {
        return "CompressionInfo{input=" + this.input + ", compressed=" + Arrays.toString(this.compressed) + ", decompressed=" + this.decompressed + ", compressedSize=" + this.compressedSize + ", compressedType=" + this.compressedType + ", compressionDescription=" + this.compressionDescription + "}";
    }

    public static DoubleCodec.CompressionInfo of(double input, byte[] compressed, double decompressed, int compressedSize, int compressedType, String compressionDescription) {
        return new ImmutableCompressionInfo(input, compressed, decompressed, compressedSize, compressedType, compressionDescription);
    }

    public static DoubleCodec.CompressionInfo copyOf(DoubleCodec.CompressionInfo instance) {
        if (instance instanceof ImmutableCompressionInfo) {
            return (ImmutableCompressionInfo)instance;
        }
        return ImmutableCompressionInfo.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="DoubleCodec.CompressionInfo", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_INPUT = 1L;
        private static final long INIT_BIT_COMPRESSED = 2L;
        private static final long INIT_BIT_DECOMPRESSED = 4L;
        private static final long INIT_BIT_COMPRESSED_SIZE = 8L;
        private static final long INIT_BIT_COMPRESSED_TYPE = 16L;
        private static final long INIT_BIT_COMPRESSION_DESCRIPTION = 32L;
        private long initBits = 63L;
        private double input;
        @Nullable
        private byte[] compressed;
        private double decompressed;
        private int compressedSize;
        private int compressedType;
        @Nullable
        private String compressionDescription;

        private Builder() {
        }

        public final Builder from(DoubleCodec.CompressionInfo instance) {
            Objects.requireNonNull(instance, "instance");
            this.input(instance.input());
            this.compressed(instance.compressed());
            this.decompressed(instance.decompressed());
            this.compressedSize(instance.compressedSize());
            this.compressedType(instance.compressedType());
            this.compressionDescription(instance.compressionDescription());
            return this;
        }

        public final Builder input(double input) {
            this.input = input;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder compressed(byte ... compressed) {
            this.compressed = (byte[])compressed.clone();
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder decompressed(double decompressed) {
            this.decompressed = decompressed;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder compressedSize(int compressedSize) {
            this.compressedSize = compressedSize;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder compressedType(int compressedType) {
            this.compressedType = compressedType;
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder compressionDescription(String compressionDescription) {
            this.compressionDescription = Objects.requireNonNull(compressionDescription, "compressionDescription");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public Builder clear() {
            this.initBits = 63L;
            this.input = 0.0;
            this.compressed = null;
            this.decompressed = 0.0;
            this.compressedSize = 0;
            this.compressedType = 0;
            this.compressionDescription = null;
            return this;
        }

        public DoubleCodec.CompressionInfo build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCompressionInfo(null, this.input, this.compressed, this.decompressed, this.compressedSize, this.compressedType, this.compressionDescription);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("input");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("compressed");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("decompressed");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("compressedSize");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("compressedType");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("compressionDescription");
            }
            return "Cannot build CompressionInfo, some of required attributes are not set " + attributes;
        }
    }
}

