/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.loading;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.neo4j.gds.core.loading.CatalogRequest;

@ParametersAreNonnullByDefault
@Generated(from="CatalogRequest", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableCatalogRequest
extends CatalogRequest {
    private final String databaseName;
    private final String requestingUsername;
    @Nullable
    private final String usernameOverride;
    private final boolean requesterIsAdmin;

    private ImmutableCatalogRequest(String databaseName, String requestingUsername, Optional<String> usernameOverride, boolean requesterIsAdmin) {
        this.databaseName = Objects.requireNonNull(databaseName, "databaseName");
        this.requestingUsername = Objects.requireNonNull(requestingUsername, "requestingUsername");
        this.usernameOverride = usernameOverride.orElse(null);
        this.requesterIsAdmin = requesterIsAdmin;
    }

    private ImmutableCatalogRequest(String databaseName, String requestingUsername, @Nullable String usernameOverride, boolean requesterIsAdmin) {
        this.databaseName = Objects.requireNonNull(databaseName, "databaseName");
        this.requestingUsername = Objects.requireNonNull(requestingUsername, "requestingUsername");
        this.usernameOverride = usernameOverride;
        this.requesterIsAdmin = requesterIsAdmin;
    }

    private ImmutableCatalogRequest(ImmutableCatalogRequest original, String databaseName, String requestingUsername, @Nullable String usernameOverride, boolean requesterIsAdmin) {
        this.databaseName = databaseName;
        this.requestingUsername = requestingUsername;
        this.usernameOverride = usernameOverride;
        this.requesterIsAdmin = requesterIsAdmin;
    }

    @Override
    public String databaseName() {
        return this.databaseName;
    }

    @Override
    public String requestingUsername() {
        return this.requestingUsername;
    }

    @Override
    public Optional<String> usernameOverride() {
        return Optional.ofNullable(this.usernameOverride);
    }

    @Override
    public boolean requesterIsAdmin() {
        return this.requesterIsAdmin;
    }

    public final ImmutableCatalogRequest withDatabaseName(String value) {
        String newValue = Objects.requireNonNull(value, "databaseName");
        if (this.databaseName.equals(newValue)) {
            return this;
        }
        return ImmutableCatalogRequest.validate(new ImmutableCatalogRequest(this, newValue, this.requestingUsername, this.usernameOverride, this.requesterIsAdmin));
    }

    public final ImmutableCatalogRequest withRequestingUsername(String value) {
        String newValue = Objects.requireNonNull(value, "requestingUsername");
        if (this.requestingUsername.equals(newValue)) {
            return this;
        }
        return ImmutableCatalogRequest.validate(new ImmutableCatalogRequest(this, this.databaseName, newValue, this.usernameOverride, this.requesterIsAdmin));
    }

    public final ImmutableCatalogRequest withUsernameOverride(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.usernameOverride, newValue)) {
            return this;
        }
        return ImmutableCatalogRequest.validate(new ImmutableCatalogRequest(this, this.databaseName, this.requestingUsername, newValue, this.requesterIsAdmin));
    }

    public final ImmutableCatalogRequest withUsernameOverride(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.usernameOverride, value)) {
            return this;
        }
        return ImmutableCatalogRequest.validate(new ImmutableCatalogRequest(this, this.databaseName, this.requestingUsername, value, this.requesterIsAdmin));
    }

    public final ImmutableCatalogRequest withRequesterIsAdmin(boolean value) {
        if (this.requesterIsAdmin == value) {
            return this;
        }
        return ImmutableCatalogRequest.validate(new ImmutableCatalogRequest(this, this.databaseName, this.requestingUsername, this.usernameOverride, value));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCatalogRequest && this.equalTo((ImmutableCatalogRequest)another);
    }

    private boolean equalTo(ImmutableCatalogRequest another) {
        return this.databaseName.equals(another.databaseName) && this.requestingUsername.equals(another.requestingUsername) && Objects.equals(this.usernameOverride, another.usernameOverride) && this.requesterIsAdmin == another.requesterIsAdmin;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.databaseName.hashCode();
        h += (h << 5) + this.requestingUsername.hashCode();
        h += (h << 5) + Objects.hashCode(this.usernameOverride);
        h += (h << 5) + Boolean.hashCode(this.requesterIsAdmin);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("CatalogRequest{");
        builder.append("databaseName=").append(this.databaseName);
        builder.append(", ");
        builder.append("requestingUsername=").append(this.requestingUsername);
        if (this.usernameOverride != null) {
            builder.append(", ");
            builder.append("usernameOverride=").append(this.usernameOverride);
        }
        builder.append(", ");
        builder.append("requesterIsAdmin=").append(this.requesterIsAdmin);
        return builder.append("}").toString();
    }

    public static CatalogRequest of(String databaseName, String requestingUsername, Optional<String> usernameOverride, boolean requesterIsAdmin) {
        return ImmutableCatalogRequest.validate(new ImmutableCatalogRequest(databaseName, requestingUsername, usernameOverride, requesterIsAdmin));
    }

    public static CatalogRequest of(String databaseName, String requestingUsername, @Nullable String usernameOverride, boolean requesterIsAdmin) {
        return ImmutableCatalogRequest.validate(new ImmutableCatalogRequest(databaseName, requestingUsername, usernameOverride, requesterIsAdmin));
    }

    private static ImmutableCatalogRequest validate(ImmutableCatalogRequest instance) {
        instance.validate();
        return instance;
    }

    public static CatalogRequest copyOf(CatalogRequest instance) {
        if (instance instanceof ImmutableCatalogRequest) {
            return (ImmutableCatalogRequest)instance;
        }
        return ImmutableCatalogRequest.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="CatalogRequest", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_DATABASE_NAME = 1L;
        private static final long INIT_BIT_REQUESTING_USERNAME = 2L;
        private static final long INIT_BIT_REQUESTER_IS_ADMIN = 4L;
        private long initBits = 7L;
        @Nullable
        private String databaseName;
        @Nullable
        private String requestingUsername;
        @Nullable
        private String usernameOverride;
        private boolean requesterIsAdmin;

        private Builder() {
        }

        public final Builder from(CatalogRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.databaseName(instance.databaseName());
            this.requestingUsername(instance.requestingUsername());
            Optional<String> usernameOverrideOptional = instance.usernameOverride();
            if (usernameOverrideOptional.isPresent()) {
                this.usernameOverride(usernameOverrideOptional);
            }
            this.requesterIsAdmin(instance.requesterIsAdmin());
            return this;
        }

        public final Builder databaseName(String databaseName) {
            this.databaseName = Objects.requireNonNull(databaseName, "databaseName");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder requestingUsername(String requestingUsername) {
            this.requestingUsername = Objects.requireNonNull(requestingUsername, "requestingUsername");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder usernameOverride(@Nullable String usernameOverride) {
            this.usernameOverride = usernameOverride;
            return this;
        }

        public final Builder usernameOverride(Optional<String> usernameOverride) {
            this.usernameOverride = usernameOverride.orElse(null);
            return this;
        }

        public final Builder requesterIsAdmin(boolean requesterIsAdmin) {
            this.requesterIsAdmin = requesterIsAdmin;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public Builder clear() {
            this.initBits = 7L;
            this.databaseName = null;
            this.requestingUsername = null;
            this.usernameOverride = null;
            this.requesterIsAdmin = false;
            return this;
        }

        public CatalogRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableCatalogRequest.validate(new ImmutableCatalogRequest(null, this.databaseName, this.requestingUsername, this.usernameOverride, this.requesterIsAdmin));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("databaseName");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("requestingUsername");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("requesterIsAdmin");
            }
            return "Cannot build CatalogRequest, some of required attributes are not set " + attributes;
        }
    }
}

