/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.loading;

import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;
import org.neo4j.gds.api.IdMap;
import org.neo4j.gds.core.loading.ArrayIdMapBuilderOps;
import org.neo4j.gds.core.loading.IdMapBuilder;
import org.neo4j.gds.core.loading.LabelInformation;
import org.neo4j.gds.core.utils.paged.HugeLongArray;
import org.neo4j.gds.core.utils.paged.HugeLongArrayBuilder;
import org.neo4j.gds.utils.AutoCloseableThreadLocal;

public final class GrowingArrayIdMapBuilder
implements IdMapBuilder {
    private final HugeLongArrayBuilder arrayBuilder;
    private final AtomicLong allocationIndex;
    private final AutoCloseableThreadLocal<HugeLongArrayBuilder.Allocator> allocators;

    public static GrowingArrayIdMapBuilder of() {
        HugeLongArrayBuilder array = HugeLongArrayBuilder.newBuilder();
        return new GrowingArrayIdMapBuilder(array);
    }

    private GrowingArrayIdMapBuilder(HugeLongArrayBuilder arrayBuilder) {
        this.arrayBuilder = arrayBuilder;
        this.allocationIndex = new AtomicLong();
        this.allocators = AutoCloseableThreadLocal.withInitial(HugeLongArrayBuilder.Allocator::new);
    }

    @Override
    @NotNull
    public HugeLongArrayBuilder.Allocator allocate(int batchLength) {
        long startIndex = this.allocationIndex.getAndAdd(batchLength);
        HugeLongArrayBuilder.Allocator allocator = (HugeLongArrayBuilder.Allocator)this.allocators.get();
        this.arrayBuilder.allocate(startIndex, batchLength, allocator);
        return allocator;
    }

    @Override
    public IdMap build(LabelInformation.Builder labelInformationBuilder, long highestNodeId, int concurrency) {
        this.allocators.close();
        long nodeCount = this.size();
        HugeLongArray graphIds = this.arrayBuilder.build(nodeCount);
        return ArrayIdMapBuilderOps.build(graphIds, nodeCount, labelInformationBuilder, highestNodeId, concurrency);
    }

    public HugeLongArray array() {
        return this.arrayBuilder.build(this.size());
    }

    public long size() {
        return this.allocationIndex.get();
    }
}

