/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.loading;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.neo4j.gds.annotation.ValueClass;
import org.neo4j.gds.api.DatabaseId;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.config.GraphProjectConfig;
import org.neo4j.gds.core.loading.CatalogRequest;
import org.neo4j.gds.core.loading.GraphStoreWithConfig;
import org.neo4j.gds.core.loading.ImmutableGraphStoreWithUserNameAndConfig;
import org.neo4j.gds.core.loading.ImmutableUserCatalogKey;
import org.neo4j.gds.utils.StringFormatting;
import org.neo4j.gds.utils.StringJoining;

public final class GraphStoreCatalog {
    private static final ConcurrentHashMap<String, UserCatalog> userCatalogs = new ConcurrentHashMap();

    private GraphStoreCatalog() {
    }

    public static GraphStoreWithConfig get(CatalogRequest request, String graphName) {
        UserCatalog.UserCatalogKey userCatalogKey = UserCatalog.UserCatalogKey.of(request.databaseName(), graphName);
        UserCatalog ownCatalog = GraphStoreCatalog.getUserCatalog(request.username());
        GraphStoreWithConfig maybeGraph = ownCatalog.get(userCatalogKey, request.restrictSearchToUsernameCatalog());
        if (maybeGraph != null) {
            return maybeGraph;
        }
        List usersWithMatchingGraphs = userCatalogs.entrySet().stream().flatMap(e -> Stream.ofNullable(((UserCatalog)e.getValue()).get(userCatalogKey, false)).map(graph -> Map.entry((String)e.getKey(), graph))).collect(Collectors.toList());
        if (usersWithMatchingGraphs.size() == 1) {
            return (GraphStoreWithConfig)((Map.Entry)usersWithMatchingGraphs.get(0)).getValue();
        }
        if (usersWithMatchingGraphs.isEmpty()) {
            throw ownCatalog.graphNotFoundException(userCatalogKey);
        }
        String usernames = StringJoining.joinVerbose((Collection)usersWithMatchingGraphs.stream().map(Map.Entry::getKey).collect(Collectors.toSet()));
        throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Multiple graphs that match '%s' are found from the users %s.", (Object[])new Object[]{graphName, usernames}));
    }

    public static void remove(CatalogRequest request, String graphName, Consumer<GraphStoreWithConfig> removedGraphConsumer, boolean failOnMissing) {
        UserCatalog.UserCatalogKey userCatalogKey = UserCatalog.UserCatalogKey.of(request.databaseName(), graphName);
        UserCatalog ownCatalog = GraphStoreCatalog.getUserCatalog(request.username());
        boolean didRemove = ownCatalog.remove(userCatalogKey, removedGraphConsumer, failOnMissing && request.restrictSearchToUsernameCatalog());
        if (didRemove || request.restrictSearchToUsernameCatalog()) {
            return;
        }
        Set usersWithMatchingGraphs = userCatalogs.entrySet().stream().flatMap(e -> Stream.ofNullable(((UserCatalog)e.getValue()).get(userCatalogKey, false)).map(graph -> (String)e.getKey())).collect(Collectors.toSet());
        if (usersWithMatchingGraphs.isEmpty() && failOnMissing) {
            throw ownCatalog.graphNotFoundException(userCatalogKey);
        }
        if (usersWithMatchingGraphs.size() > 1) {
            String usernames = StringJoining.joinVerbose(usersWithMatchingGraphs);
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Multiple graphs that match '%s' are found from the users %s.", (Object[])new Object[]{graphName, usernames}));
        }
        if (!usersWithMatchingGraphs.isEmpty()) {
            String username = (String)usersWithMatchingGraphs.iterator().next();
            GraphStoreCatalog.getUserCatalog(username).remove(userCatalogKey, removedGraphConsumer, failOnMissing);
        }
    }

    @TestOnly
    public static GraphStoreWithConfig get(String username, DatabaseId databaseId, String graphName) {
        return GraphStoreCatalog.get(CatalogRequest.of(username, databaseId), graphName);
    }

    @TestOnly
    public static GraphStoreWithConfig get(String username, String databaseName, String graphName) {
        return GraphStoreCatalog.get(CatalogRequest.of(username, databaseName), graphName);
    }

    public static void set(GraphProjectConfig config, GraphStore graphStore) {
        GraphStoreCatalog.set(config, graphStore, false);
    }

    public static void overwrite(GraphProjectConfig config, GraphStore graphStore) {
        GraphStoreCatalog.set(config, graphStore, true);
    }

    private static void set(GraphProjectConfig config, GraphStore graphStore, boolean overwrite) {
        graphStore.canRelease(false);
        userCatalogs.compute(config.username(), (user, userCatalog) -> {
            if (userCatalog == null) {
                userCatalog = new UserCatalog();
            }
            userCatalog.set(UserCatalog.UserCatalogKey.of(graphStore.databaseId(), config.graphName()), config, graphStore, overwrite);
            return userCatalog;
        });
    }

    public static boolean exists(String username, String databaseName, String graphName) {
        return GraphStoreCatalog.getUserCatalog(username).exists(UserCatalog.UserCatalogKey.of(databaseName, graphName));
    }

    public static boolean exists(String username, DatabaseId databaseId, String graphName) {
        return GraphStoreCatalog.getUserCatalog(username).exists(UserCatalog.UserCatalogKey.of(databaseId, graphName));
    }

    public static int graphStoresCount() {
        return userCatalogs.values().stream().mapToInt(userCatalog -> userCatalog.getGraphStores().values().size()).sum();
    }

    public static int graphStoresCount(DatabaseId databaseId) {
        return userCatalogs.values().stream().mapToInt(userCatalog -> userCatalog.getGraphStores(databaseId).values().size()).sum();
    }

    public static boolean isEmpty() {
        return GraphStoreCatalog.graphStoresCount() == 0;
    }

    public static Optional<Map<String, Object>> getDegreeDistribution(String username, DatabaseId databaseId, String graphName) {
        return GraphStoreCatalog.getUserCatalog(username).getDegreeDistribution(UserCatalog.UserCatalogKey.of(databaseId, graphName));
    }

    public static void setDegreeDistribution(String username, DatabaseId databaseId, String graphName, Map<String, Object> degreeDistribution) {
        GraphStoreCatalog.getUserCatalog(username).setDegreeDistribution(UserCatalog.UserCatalogKey.of(databaseId, graphName), degreeDistribution);
    }

    public static void removeAllLoadedGraphs() {
        userCatalogs.clear();
    }

    public static void removeAllLoadedGraphs(DatabaseId databaseId) {
        userCatalogs.forEach((user, userCatalog) -> userCatalog.remove(databaseId.databaseName()));
    }

    public static Map<GraphProjectConfig, GraphStore> getGraphStores(String username) {
        return GraphStoreCatalog.getUserCatalog(username).getGraphStores();
    }

    public static Map<GraphProjectConfig, GraphStore> getGraphStores(String username, DatabaseId databaseId) {
        return GraphStoreCatalog.getUserCatalog(username).getGraphStores(databaseId);
    }

    public static Stream<GraphStoreWithUserNameAndConfig> getAllGraphStores() {
        return userCatalogs.entrySet().stream().flatMap(entry -> ((UserCatalog)entry.getValue()).streamGraphStores((String)entry.getKey()));
    }

    private static UserCatalog getUserCatalog(String username) {
        return userCatalogs.getOrDefault(username, UserCatalog.EMPTY);
    }

    static class UserCatalog {
        private static final UserCatalog EMPTY = new UserCatalog();
        private final Map<UserCatalogKey, GraphStoreWithConfig> graphsByName = new ConcurrentHashMap<UserCatalogKey, GraphStoreWithConfig>();
        private final Map<UserCatalogKey, Map<String, Object>> degreeDistributionByName = new ConcurrentHashMap<UserCatalogKey, Map<String, Object>>();

        UserCatalog() {
        }

        private void set(UserCatalogKey userCatalogKey, GraphProjectConfig config, GraphStore graphStore, boolean overwrite) {
            if (config.graphName() == null || graphStore == null) {
                throw new IllegalArgumentException("Both name and graph store must be not null");
            }
            GraphStoreWithConfig graphStoreWithConfig = GraphStoreWithConfig.of(graphStore, config);
            if (!overwrite && this.graphsByName.containsKey(userCatalogKey)) {
                throw new IllegalStateException(StringFormatting.formatWithLocale((String)"Graph name %s already loaded", (Object[])new Object[]{config.graphName()}));
            }
            this.graphsByName.put(userCatalogKey, graphStoreWithConfig);
            graphStore.canRelease(false);
        }

        private void setDegreeDistribution(UserCatalogKey userCatalogKey, Map<String, Object> degreeDistribution) {
            if (userCatalogKey == null || degreeDistribution == null) {
                throw new IllegalArgumentException("Both name and degreeDistribution must be not null");
            }
            if (!this.graphsByName.containsKey(userCatalogKey)) {
                throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Cannot set degreeDistribution because graph %s does not exist", (Object[])new Object[]{userCatalogKey.graphName()}));
            }
            this.degreeDistributionByName.put(userCatalogKey, degreeDistribution);
        }

        private void removeDegreeDistribution(UserCatalogKey userCatalogKey) {
            this.degreeDistributionByName.remove(userCatalogKey);
        }

        @Nullable
        private GraphStoreWithConfig get(UserCatalogKey userCatalogKey, boolean failOnMissing) {
            GraphStoreWithConfig graphStoreWithConfig = this.graphsByName.get(userCatalogKey);
            if (graphStoreWithConfig == null && failOnMissing) {
                throw this.graphNotFoundException(userCatalogKey);
            }
            return graphStoreWithConfig;
        }

        private NoSuchElementException graphNotFoundException(UserCatalogKey userCatalogKey) {
            String graphName = userCatalogKey.graphName();
            return new NoSuchElementException(StringFormatting.formatWithLocale((String)"Graph with name `%s` does not exist on database `%s`. It might exist on another database.", (Object[])new Object[]{graphName, userCatalogKey.databaseName()}));
        }

        private Optional<Map<String, Object>> getDegreeDistribution(UserCatalogKey userCatalogKey) {
            if (!this.graphsByName.containsKey(userCatalogKey)) {
                return Optional.empty();
            }
            return Optional.ofNullable(this.degreeDistributionByName.get(userCatalogKey));
        }

        private boolean exists(UserCatalogKey userCatalogKey) {
            return userCatalogKey != null && this.graphsByName.containsKey(userCatalogKey);
        }

        private boolean remove(UserCatalogKey userCatalogKey, Consumer<GraphStoreWithConfig> removedGraphConsumer, boolean failOnMissing) {
            return Optional.ofNullable(this.get(userCatalogKey, failOnMissing)).map(graphStoreWithConfig -> {
                removedGraphConsumer.accept((GraphStoreWithConfig)graphStoreWithConfig);
                graphStoreWithConfig.graphStore().canRelease(true);
                graphStoreWithConfig.graphStore().release();
                this.removeDegreeDistribution(userCatalogKey);
                this.graphsByName.remove(userCatalogKey);
                return Boolean.TRUE;
            }).orElse(Boolean.FALSE);
        }

        private void remove(String databaseName) {
            this.graphsByName.keySet().removeIf(userCatalogKey -> userCatalogKey.databaseName().equals(databaseName));
        }

        private Stream<GraphStoreWithUserNameAndConfig> streamGraphStores(String userName) {
            return this.graphsByName.values().stream().map(graphStoreWithConfig -> ImmutableGraphStoreWithUserNameAndConfig.of(graphStoreWithConfig.graphStore(), userName, graphStoreWithConfig.config()));
        }

        private Map<GraphProjectConfig, GraphStore> getGraphStores() {
            return this.graphsByName.values().stream().collect(Collectors.toMap(GraphStoreWithConfig::config, GraphStoreWithConfig::graphStore));
        }

        private Map<GraphProjectConfig, GraphStore> getGraphStores(DatabaseId databaseId) {
            return this.graphsByName.entrySet().stream().filter(entry -> ((UserCatalogKey)entry.getKey()).databaseName().equals(databaseId.databaseName())).collect(Collectors.toMap(entry -> ((GraphStoreWithConfig)entry.getValue()).config(), entry -> ((GraphStoreWithConfig)entry.getValue()).graphStore()));
        }

        @ValueClass
        public static interface UserCatalogKey {
            public String graphName();

            public String databaseName();

            public static UserCatalogKey of(DatabaseId databaseId, String graphName) {
                return UserCatalogKey.of(databaseId.databaseName(), graphName);
            }

            public static UserCatalogKey of(String databaseName, String graphName) {
                return ImmutableUserCatalogKey.of(graphName, databaseName);
            }
        }
    }

    @ValueClass
    public static interface GraphStoreWithUserNameAndConfig {
        public GraphStore graphStore();

        public String userName();

        public GraphProjectConfig config();
    }
}

