/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.loading;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.api.DatabaseId;
import org.neo4j.gds.api.IdMap;
import org.neo4j.gds.api.RelationshipPropertyStore;
import org.neo4j.gds.api.Relationships;
import org.neo4j.gds.api.properties.graph.GraphPropertyStore;
import org.neo4j.gds.api.properties.nodes.NodePropertyStore;
import org.neo4j.gds.api.schema.GraphSchema;
import org.neo4j.gds.core.loading.CSRGraphStore;
import org.neo4j.gds.core.loading.Capabilities;

@ParametersAreNonnullByDefault
@Generated(from="CSRGraphStore.of", generator="Immutables")
@SuppressFBWarnings
@NotThreadSafe
public final class GraphStoreBuilder {
    private static final long INIT_BIT_DATABASE_ID = 1L;
    private static final long INIT_BIT_CAPABILITIES = 2L;
    private static final long INIT_BIT_SCHEMA = 4L;
    private static final long INIT_BIT_NODES = 8L;
    private static final long INIT_BIT_CONCURRENCY = 16L;
    private long initBits = 31L;
    @javax.annotation.Nullable
    private DatabaseId databaseId;
    @javax.annotation.Nullable
    private Capabilities capabilities;
    @javax.annotation.Nullable
    private GraphSchema schema;
    @javax.annotation.Nullable
    private IdMap nodes;
    @javax.annotation.Nullable
    private NodePropertyStore nodePropertyStore;
    private Map<RelationshipType, Relationships.Topology> relationships = new LinkedHashMap<RelationshipType, Relationships.Topology>();
    private Map<RelationshipType, RelationshipPropertyStore> relationshipPropertyStores = new LinkedHashMap<RelationshipType, RelationshipPropertyStore>();
    private Optional<GraphPropertyStore> graphProperties = Optional.empty();
    private int concurrency;

    public final GraphStoreBuilder databaseId(DatabaseId databaseId) {
        this.databaseId = Objects.requireNonNull(databaseId, "databaseId");
        this.initBits &= 0xFFFFFFFFFFFFFFFEL;
        return this;
    }

    public final GraphStoreBuilder capabilities(Capabilities capabilities) {
        this.capabilities = Objects.requireNonNull(capabilities, "capabilities");
        this.initBits &= 0xFFFFFFFFFFFFFFFDL;
        return this;
    }

    public final GraphStoreBuilder schema(GraphSchema schema) {
        this.schema = Objects.requireNonNull(schema, "schema");
        this.initBits &= 0xFFFFFFFFFFFFFFFBL;
        return this;
    }

    public final GraphStoreBuilder nodes(IdMap nodes) {
        this.nodes = Objects.requireNonNull(nodes, "nodes");
        this.initBits &= 0xFFFFFFFFFFFFFFF7L;
        return this;
    }

    public final GraphStoreBuilder nodePropertyStore(@Nullable NodePropertyStore nodePropertyStore) {
        this.nodePropertyStore = nodePropertyStore;
        return this;
    }

    public final GraphStoreBuilder putRelationships(RelationshipType key, Relationships.Topology value) {
        this.relationships.put(Objects.requireNonNull(key, "relationships key"), Objects.requireNonNull(value, "relationships value"));
        return this;
    }

    public final GraphStoreBuilder putRelationships(Map.Entry<? extends RelationshipType, ? extends Relationships.Topology> entry) {
        RelationshipType k = entry.getKey();
        Relationships.Topology v = entry.getValue();
        this.relationships.put(Objects.requireNonNull(k, "relationships key"), Objects.requireNonNull(v, "relationships value"));
        return this;
    }

    public final GraphStoreBuilder relationships(Map<? extends RelationshipType, ? extends Relationships.Topology> entries) {
        this.relationships.clear();
        return this.putAllRelationships(entries);
    }

    public final GraphStoreBuilder putAllRelationships(Map<? extends RelationshipType, ? extends Relationships.Topology> entries) {
        for (Map.Entry<? extends RelationshipType, ? extends Relationships.Topology> e : entries.entrySet()) {
            RelationshipType k = e.getKey();
            Relationships.Topology v = e.getValue();
            this.relationships.put(Objects.requireNonNull(k, "relationships key"), Objects.requireNonNull(v, "relationships value"));
        }
        return this;
    }

    public final GraphStoreBuilder putRelationshipPropertyStores(RelationshipType key, RelationshipPropertyStore value) {
        this.relationshipPropertyStores.put(Objects.requireNonNull(key, "relationshipPropertyStores key"), Objects.requireNonNull(value, "relationshipPropertyStores value"));
        return this;
    }

    public final GraphStoreBuilder putRelationshipPropertyStores(Map.Entry<? extends RelationshipType, ? extends RelationshipPropertyStore> entry) {
        RelationshipType k = entry.getKey();
        RelationshipPropertyStore v = entry.getValue();
        this.relationshipPropertyStores.put(Objects.requireNonNull(k, "relationshipPropertyStores key"), Objects.requireNonNull(v, "relationshipPropertyStores value"));
        return this;
    }

    public final GraphStoreBuilder relationshipPropertyStores(Map<? extends RelationshipType, ? extends RelationshipPropertyStore> entries) {
        this.relationshipPropertyStores.clear();
        return this.putAllRelationshipPropertyStores(entries);
    }

    public final GraphStoreBuilder putAllRelationshipPropertyStores(Map<? extends RelationshipType, ? extends RelationshipPropertyStore> entries) {
        for (Map.Entry<? extends RelationshipType, ? extends RelationshipPropertyStore> e : entries.entrySet()) {
            RelationshipType k = e.getKey();
            RelationshipPropertyStore v = e.getValue();
            this.relationshipPropertyStores.put(Objects.requireNonNull(k, "relationshipPropertyStores key"), Objects.requireNonNull(v, "relationshipPropertyStores value"));
        }
        return this;
    }

    public final GraphStoreBuilder graphProperties(GraphPropertyStore graphProperties) {
        this.graphProperties = Optional.of(graphProperties);
        return this;
    }

    public final GraphStoreBuilder graphProperties(Optional<? extends GraphPropertyStore> graphProperties) {
        this.graphProperties = Objects.requireNonNull(graphProperties, "graphProperties");
        return this;
    }

    public final GraphStoreBuilder concurrency(int concurrency) {
        this.concurrency = concurrency;
        this.initBits &= 0xFFFFFFFFFFFFFFEFL;
        return this;
    }

    public CSRGraphStore build() {
        this.checkRequiredAttributes();
        return CSRGraphStore.of(this.databaseId, this.capabilities, this.schema, this.nodes, this.nodePropertyStore, GraphStoreBuilder.createUnmodifiableMap(false, false, this.relationships), GraphStoreBuilder.createUnmodifiableMap(false, false, this.relationshipPropertyStores), this.graphProperties, this.concurrency);
    }

    private boolean databaseIdIsSet() {
        return (this.initBits & 1L) == 0L;
    }

    private boolean capabilitiesIsSet() {
        return (this.initBits & 2L) == 0L;
    }

    private boolean schemaIsSet() {
        return (this.initBits & 4L) == 0L;
    }

    private boolean nodesIsSet() {
        return (this.initBits & 8L) == 0L;
    }

    private boolean concurrencyIsSet() {
        return (this.initBits & 0x10L) == 0L;
    }

    private void checkRequiredAttributes() {
        if (this.initBits != 0L) {
            throw new IllegalStateException(this.formatRequiredAttributesMessage());
        }
    }

    private String formatRequiredAttributesMessage() {
        ArrayList<String> attributes = new ArrayList<String>();
        if (!this.databaseIdIsSet()) {
            attributes.add("databaseId");
        }
        if (!this.capabilitiesIsSet()) {
            attributes.add("capabilities");
        }
        if (!this.schemaIsSet()) {
            attributes.add("schema");
        }
        if (!this.nodesIsSet()) {
            attributes.add("nodes");
        }
        if (!this.concurrencyIsSet()) {
            attributes.add("concurrency");
        }
        return "Cannot build of, some of required attributes are not set " + attributes;
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }
}

