/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.loading;

import java.util.Arrays;
import org.apache.commons.lang3.mutable.MutableDouble;
import org.jetbrains.annotations.TestOnly;
import org.neo4j.gds.annotation.ValueClass;

public abstract class DoubleCodec {
    static final int SIGNIFICAND_WIDTH = 53;
    protected static final int SIGNIFICAND_BITS = 52;
    static final int EXPONENT_BITS = 11;
    protected static final int EXP_BIAS = 1023;
    protected static final int SUPER_NORMAL_EXPONENT = 2047;
    static final long SIGN_BIT_MASK = Long.MIN_VALUE;
    protected static final long EXP_BIT_MASK = 0x7FF0000000000000L;
    protected static final long SIGNIFICANT_BIT_MASK = 0xFFFFFFFFFFFFFL;

    protected static byte getSign(long bits) {
        long signBit = (bits & Long.MIN_VALUE) >>> 63;
        return (byte)signBit;
    }

    protected static int getUnbiasedExponent(long bits) {
        return (int)((bits & 0x7FF0000000000000L) >>> 52);
    }

    protected static long getSignificand(long bits) {
        return bits & 0xFFFFFFFFFFFFFL;
    }

    public int compressDoubles(double[] data, int length, byte[] out) {
        int outPos = 0;
        length = Math.min(data.length, length);
        for (int i = 0; i < length; ++i) {
            long bits = Double.doubleToRawLongBits(data[i]);
            outPos = this.compressDouble(bits, out, outPos);
        }
        return outPos;
    }

    int compressDoubles(long[] data, int length, byte[] out) {
        int outPos = 0;
        length = Math.min(data.length, length);
        for (int i = 0; i < length; ++i) {
            long datum = data[i];
            outPos = this.compressDouble(datum, out, outPos);
        }
        return outPos;
    }

    byte[] compressDoubles(double[] data) {
        byte[] out = new byte[10 * data.length];
        int outPos = 0;
        for (double datum : data) {
            byte[] bytes = this.compressDouble(datum);
            System.arraycopy(bytes, 0, out, outPos, bytes.length);
            outPos += bytes.length;
        }
        return Arrays.copyOf(out, outPos);
    }

    byte[] compressDouble(double value) {
        byte[] out = new byte[10];
        int outLength = this.compressDouble(value, out);
        return Arrays.copyOf(out, outLength);
    }

    public int compressDouble(double value, byte[] out) {
        long bits = Double.doubleToRawLongBits(value);
        return this.compressDouble(bits, out, 0);
    }

    double decompressDouble(byte[] data) {
        return this.decompressDouble(data, 0);
    }

    public double[] decompressDoubles(byte[] data, int length) {
        return this.decompressDoubles(data, 0, length);
    }

    double[] decompressDoubles(byte[] data, int pos, int length) {
        double[] out = new double[length];
        this.decompressDoubles(data, pos, length, out, 0);
        return out;
    }

    int decompressDoubles(byte[] data, int length, double[] out, int outPos) {
        return this.decompressDoubles(data, 0, length, out, outPos);
    }

    int decompressDoubles(byte[] data, int inPos, int length, double[] out, int outPos) {
        MutableDouble value = new MutableDouble();
        for (int i = 0; i < length; ++i) {
            inPos = this.decompressDouble(data, inPos, value);
            out[outPos++] = value.doubleValue();
        }
        return outPos;
    }

    public abstract int compressDouble(long var1, byte[] var3, int var4);

    public abstract int decompressDouble(byte[] var1, int var2, MutableDouble var3);

    public double decompressDouble(byte[] data, int pos) {
        MutableDouble out = new MutableDouble();
        this.decompressDouble(data, pos, out);
        return out.doubleValue();
    }

    public abstract int compressedSize(byte[] var1, int var2);

    @TestOnly
    public abstract String describeCompression(int var1);

    @TestOnly
    public abstract CompressionInfo describeCompressedValue(byte[] var1, int var2, double var3);

    @TestOnly
    public int supportedSignificandWith() {
        return 53;
    }

    @ValueClass
    @TestOnly
    public static interface CompressionInfo {
        public double input();

        public byte[] compressed();

        public double decompressed();

        public int compressedSize();

        public int compressedType();

        public String compressionDescription();
    }
}

