/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.loading;

import java.util.Arrays;
import java.util.function.LongSupplier;
import org.neo4j.gds.PropertyMappings;
import org.neo4j.gds.api.AdjacencyList;
import org.neo4j.gds.api.AdjacencyProperties;
import org.neo4j.gds.core.Aggregation;
import org.neo4j.gds.core.compress.AdjacencyCompressor;
import org.neo4j.gds.core.compress.AdjacencyCompressorFactory;
import org.neo4j.gds.core.compress.LongArrayBuffer;
import org.neo4j.gds.core.loading.AbstractAdjacencyCompressorFactory;
import org.neo4j.gds.core.loading.AdjacencyCompression;
import org.neo4j.gds.core.loading.AdjacencyListBuilder;
import org.neo4j.gds.core.loading.AdjacencyListBuilderFactory;
import org.neo4j.gds.core.loading.ZigZagLongDecoding;
import org.neo4j.gds.core.utils.paged.HugeIntArray;
import org.neo4j.gds.core.utils.paged.HugeLongArray;

public final class DeltaVarLongCompressor
implements AdjacencyCompressor {
    private final AdjacencyListBuilder.Allocator<byte[]> adjacencyAllocator;
    private final AdjacencyListBuilder.Allocator<long[]>[] propertiesAllocators;
    private final HugeIntArray adjacencyDegrees;
    private final HugeLongArray adjacencyOffsets;
    private final HugeLongArray propertyOffsets;
    private final boolean noAggregation;
    private final Aggregation[] aggregations;

    public static AdjacencyCompressorFactory factory(LongSupplier nodeCountSupplier, AdjacencyListBuilderFactory<byte[], ? extends AdjacencyList, long[], ? extends AdjacencyProperties> adjacencyListBuilderFactory, PropertyMappings propertyMappings, Aggregation[] aggregations, boolean noAggregation) {
        AdjacencyListBuilder[] propertyBuilders = new AdjacencyListBuilder[propertyMappings.numberOfMappings()];
        Arrays.setAll(propertyBuilders, i -> adjacencyListBuilderFactory.newAdjacencyPropertiesBuilder());
        return new Factory(nodeCountSupplier, adjacencyListBuilderFactory.newAdjacencyListBuilder(), propertyBuilders, noAggregation, aggregations);
    }

    private DeltaVarLongCompressor(AdjacencyListBuilder.Allocator<byte[]> adjacencyAllocator, AdjacencyListBuilder.Allocator<long[]>[] propertiesAllocators, HugeIntArray adjacencyDegrees, HugeLongArray adjacencyOffsets, HugeLongArray propertyOffsets, boolean noAggregation, Aggregation[] aggregations) {
        this.adjacencyAllocator = adjacencyAllocator;
        this.propertiesAllocators = propertiesAllocators;
        this.adjacencyDegrees = adjacencyDegrees;
        this.adjacencyOffsets = adjacencyOffsets;
        this.propertyOffsets = propertyOffsets;
        this.noAggregation = noAggregation;
        this.aggregations = aggregations;
    }

    @Override
    public int compress(long nodeId, byte[] targets, long[][] properties, int numberOfCompressedTargets, int compressedBytesSize, LongArrayBuffer buffer, AdjacencyCompressor.ValueMapper mapper) {
        if (properties != null) {
            return this.applyVariableDeltaEncodingWithProperties(nodeId, targets, properties, numberOfCompressedTargets, compressedBytesSize, buffer, mapper);
        }
        return this.applyVariableDeltaEncodingWithoutProperties(nodeId, targets, numberOfCompressedTargets, compressedBytesSize, buffer, mapper);
    }

    @Override
    public void close() {
        this.adjacencyAllocator.close();
        for (AdjacencyListBuilder.Allocator<long[]> propertiesAllocator : this.propertiesAllocators) {
            if (propertiesAllocator == null) continue;
            propertiesAllocator.close();
        }
    }

    private int applyVariableDeltaEncodingWithoutProperties(long nodeId, byte[] semiCompressedBytesDuringLoading, int numberOfCompressedTargets, int compressedByteSize, LongArrayBuffer buffer, AdjacencyCompressor.ValueMapper mapper) {
        AdjacencyCompression.copyFrom(buffer, semiCompressedBytesDuringLoading, numberOfCompressedTargets, compressedByteSize, mapper);
        int degree = AdjacencyCompression.applyDeltaEncoding(buffer, this.aggregations[0]);
        if (mapper != ZigZagLongDecoding.Identity.INSTANCE) {
            semiCompressedBytesDuringLoading = AdjacencyCompression.ensureBufferSize(buffer, semiCompressedBytesDuringLoading);
        }
        int requiredBytes = AdjacencyCompression.compress(buffer, semiCompressedBytesDuringLoading);
        long address = this.copyIds(semiCompressedBytesDuringLoading, requiredBytes);
        this.adjacencyDegrees.set(nodeId, degree);
        this.adjacencyOffsets.set(nodeId, address);
        return degree;
    }

    private int applyVariableDeltaEncodingWithProperties(long nodeId, byte[] semiCompressedBytesDuringLoading, long[][] uncompressedPropertiesPerProperty, int numberOfCompressedTargets, int compressedByteSize, LongArrayBuffer buffer, AdjacencyCompressor.ValueMapper mapper) {
        AdjacencyCompression.copyFrom(buffer, semiCompressedBytesDuringLoading, numberOfCompressedTargets, compressedByteSize, mapper);
        int degree = AdjacencyCompression.applyDeltaEncoding(buffer, uncompressedPropertiesPerProperty, this.aggregations, this.noAggregation);
        if (mapper != ZigZagLongDecoding.Identity.INSTANCE) {
            semiCompressedBytesDuringLoading = AdjacencyCompression.ensureBufferSize(buffer, semiCompressedBytesDuringLoading);
        }
        int requiredBytes = AdjacencyCompression.compress(buffer, semiCompressedBytesDuringLoading);
        long address = this.copyIds(semiCompressedBytesDuringLoading, requiredBytes);
        this.copyProperties(uncompressedPropertiesPerProperty, degree, nodeId, this.propertyOffsets);
        this.adjacencyDegrees.set(nodeId, degree);
        this.adjacencyOffsets.set(nodeId, address);
        return degree;
    }

    private long copyIds(byte[] targets, int requiredBytes) {
        return this.adjacencyAllocator.write(targets, requiredBytes, -1L);
    }

    private void copyProperties(long[][] properties, int degree, long nodeId, HugeLongArray offsets) {
        long offset = this.propertiesAllocators[0].write(properties[0], degree, -1L);
        for (int i = 1; i < properties.length; ++i) {
            this.propertiesAllocators[i].write(properties[i], degree, offset);
        }
        offsets.set(nodeId, offset);
    }

    private static final class Factory
    extends AbstractAdjacencyCompressorFactory<byte[], long[]> {
        Factory(LongSupplier nodeCountSupplier, AdjacencyListBuilder<byte[], ? extends AdjacencyList> adjacencyBuilder, AdjacencyListBuilder<long[], ? extends AdjacencyProperties>[] propertyBuilders, boolean noAggregation, Aggregation[] aggregations) {
            super(nodeCountSupplier, adjacencyBuilder, propertyBuilders, noAggregation, aggregations);
        }

        @Override
        public DeltaVarLongCompressor createCompressor() {
            AdjacencyListBuilder.Allocator[] propertyAllocators = new AdjacencyListBuilder.Allocator[this.propertyBuilders.length];
            Arrays.setAll(propertyAllocators, i -> i == 0 ? this.propertyBuilders[i].newAllocator() : this.propertyBuilders[i].newPositionalAllocator());
            return new DeltaVarLongCompressor(this.adjacencyBuilder.newAllocator(), propertyAllocators, this.adjacencyDegrees, this.adjacencyOffsets, this.propertyOffsets, this.noAggregation, this.aggregations);
        }
    }
}

