/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.loading;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.mutable.MutableInt;
import org.eclipse.collections.api.map.primitive.ObjectDoubleMap;
import org.eclipse.collections.impl.map.mutable.primitive.ObjectDoubleHashMap;
import org.eclipse.collections.impl.map.mutable.primitive.ObjectIntHashMap;
import org.immutables.value.Value;
import org.neo4j.gds.AbstractRelationshipProjection;
import org.neo4j.gds.Orientation;
import org.neo4j.gds.PropertyMapping;
import org.neo4j.gds.PropertyMappings;
import org.neo4j.gds.RelationshipProjection;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.api.DefaultValue;
import org.neo4j.gds.api.GraphLoaderContext;
import org.neo4j.gds.api.IdMap;
import org.neo4j.gds.api.Relationships;
import org.neo4j.gds.config.GraphProjectFromCypherConfig;
import org.neo4j.gds.core.Aggregation;
import org.neo4j.gds.core.loading.BatchLoadResult;
import org.neo4j.gds.core.loading.CypherLoadingUtils;
import org.neo4j.gds.core.loading.CypherRecordLoader;
import org.neo4j.gds.core.loading.RelationshipSubscriber;
import org.neo4j.gds.core.loading.RelationshipsAndProperties;
import org.neo4j.gds.core.loading.construction.GraphFactory;
import org.neo4j.gds.core.loading.construction.NodesBuilder;
import org.neo4j.gds.core.loading.construction.RelationshipsBuilder;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.query.QueryExecution;

@Value.Enclosing
class CypherRelationshipLoader
extends CypherRecordLoader<RelationshipsAndProperties> {
    private final IdMap idMap;
    private final Context loaderContext;
    private final ProgressTracker progressTracker;
    private ObjectIntHashMap<String> propertyKeyIdsByName;
    private ObjectDoubleHashMap<String> propertyDefaultValueByName;
    private boolean initializedFromResult;
    private List<GraphFactory.PropertyConfig> propertyConfigs;
    private AbstractRelationshipProjection.Builder projectionBuilder;

    CypherRelationshipLoader(String relationshipQuery, IdMap idMap, GraphProjectFromCypherConfig config, GraphLoaderContext loadingContext, ProgressTracker progressTracker) {
        super(relationshipQuery, idMap.nodeCount(), config, loadingContext);
        this.idMap = idMap;
        this.progressTracker = progressTracker;
        this.loaderContext = new Context();
    }

    private void initFromPropertyMappings(PropertyMappings propertyMappings) {
        MutableInt propertyKeyId = new MutableInt(0);
        int numberOfMappings = propertyMappings.numberOfMappings();
        this.propertyKeyIdsByName = new ObjectIntHashMap(numberOfMappings);
        propertyMappings.stream().forEach(mapping -> this.propertyKeyIdsByName.put((Object)mapping.neoPropertyKey(), propertyKeyId.getAndIncrement()));
        this.propertyDefaultValueByName = new ObjectDoubleHashMap(numberOfMappings);
        propertyMappings.stream().forEach(mapping -> this.propertyDefaultValueByName.put((Object)mapping.neoPropertyKey(), mapping.defaultValue().doubleValue()));
        this.propertyConfigs = propertyMappings.stream().map(mapping -> GraphFactory.PropertyConfig.of(mapping.aggregation(), mapping.defaultValue())).collect(Collectors.toList());
        this.projectionBuilder = RelationshipProjection.builder().orientation(Orientation.NATURAL).properties(propertyMappings);
    }

    @Override
    BatchLoadResult loadSingleBatch(InternalTransaction tx, int bufferSize) {
        this.progressTracker.beginSubTask("Relationships");
        RelationshipSubscriber subscriber = new RelationshipSubscriber(this.idMap, this.loaderContext, this.cypherConfig.validateRelationships(), this.progressTracker);
        QueryExecution subscription = this.runLoadingQuery(tx, subscriber);
        if (!this.initializedFromResult) {
            List propertyMappings = this.getPropertyColumns(subscription).stream().map(propertyColumn -> PropertyMapping.of((String)propertyColumn, (String)propertyColumn, (DefaultValue)NodesBuilder.NO_PROPERTY_VALUE, (Aggregation)Aggregation.NONE)).collect(Collectors.toList());
            this.initFromPropertyMappings(PropertyMappings.of(propertyMappings));
            this.initializedFromResult = true;
        }
        subscriber.initialize(subscription.fieldNames(), (ObjectDoubleMap<String>)this.propertyDefaultValueByName);
        CypherLoadingUtils.consume(subscription);
        this.progressTracker.endSubTask("Relationships");
        return new BatchLoadResult(subscriber.rows(), -1L);
    }

    @Override
    void updateCounts(BatchLoadResult result) {
    }

    @Override
    RelationshipsAndProperties result() {
        Map<RelationshipsAndProperties.RelationshipTypeAndProjection, List<Relationships>> relationshipsByType = this.loaderContext.relationshipBuildersByType.entrySet().stream().collect(Collectors.toMap(entry -> {
            RelationshipProjection projection = this.projectionBuilder.type(((RelationshipType)entry.getKey()).name).build();
            return RelationshipsAndProperties.RelationshipTypeAndProjection.of((RelationshipType)entry.getKey(), projection);
        }, entry -> ((RelationshipsBuilder)entry.getValue()).buildAll()));
        return RelationshipsAndProperties.of(relationshipsByType);
    }

    @Override
    Set<String> getMandatoryColumns() {
        return RelationshipSubscriber.REQUIRED_COLUMNS;
    }

    @Override
    Set<String> getReservedColumns() {
        return RelationshipSubscriber.RESERVED_COLUMNS;
    }

    @Override
    CypherRecordLoader.QueryType queryType() {
        return CypherRecordLoader.QueryType.RELATIONSHIP;
    }

    class Context {
        private final Map<RelationshipType, RelationshipsBuilder> relationshipBuildersByType = new HashMap<RelationshipType, RelationshipsBuilder>();

        Context() {
        }

        RelationshipsBuilder getOrCreateRelationshipsBuilder(RelationshipType relationshipType) {
            return this.relationshipBuildersByType.computeIfAbsent(relationshipType, this::createRelationshipsBuilder);
        }

        private RelationshipsBuilder createRelationshipsBuilder(RelationshipType relationshipType) {
            return GraphFactory.initRelationshipsBuilder().nodes(CypherRelationshipLoader.this.idMap).concurrency(CypherRelationshipLoader.this.cypherConfig.readConcurrency()).propertyConfigs(CypherRelationshipLoader.this.propertyConfigs).orientation(Orientation.NATURAL).validateRelationships(CypherRelationshipLoader.this.cypherConfig.validateRelationships()).build();
        }
    }
}

