/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.loading;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.immutables.value.Value;
import org.neo4j.gds.PropertyMapping;
import org.neo4j.gds.api.GraphLoaderContext;
import org.neo4j.gds.api.IdMap;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.config.GraphProjectFromCypherConfig;
import org.neo4j.gds.core.loading.BatchLoadResult;
import org.neo4j.gds.core.loading.CypherLoadingUtils;
import org.neo4j.gds.core.loading.CypherRecordLoader;
import org.neo4j.gds.core.loading.IdMapAndProperties;
import org.neo4j.gds.core.loading.NodeSubscriber;
import org.neo4j.gds.core.loading.construction.GraphFactory;
import org.neo4j.gds.core.loading.construction.NodesBuilder;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.query.QueryExecution;

@Value.Enclosing
class CypherNodeLoader
extends CypherRecordLoader<IdMapAndProperties> {
    private final long nodeCount;
    private final ProgressTracker progressTracker;
    private long highestNodeId;
    private NodesBuilder nodesBuilder;

    CypherNodeLoader(String nodeQuery, long nodeCount, GraphProjectFromCypherConfig config, GraphLoaderContext loadingContext, ProgressTracker progressTracker) {
        super(nodeQuery, nodeCount, config, loadingContext);
        this.nodeCount = nodeCount;
        this.progressTracker = progressTracker;
        this.highestNodeId = 0L;
    }

    @Override
    BatchLoadResult loadSingleBatch(InternalTransaction tx, int bufferSize) {
        long rows;
        this.progressTracker.beginSubTask("Nodes");
        this.progressTracker.setVolume(this.nodeCount);
        NodeSubscriber nodeSubscriber = new NodeSubscriber(this.progressTracker);
        QueryExecution subscription = this.runLoadingQuery(tx, nodeSubscriber);
        Collection<String> propertyColumns = this.getPropertyColumns(subscription);
        boolean hasLabelInformation = this.columnsContains(subscription, "labels");
        this.nodesBuilder = GraphFactory.initNodesBuilder().nodeCount(this.nodeCount).maxOriginalId(-1L).hasLabelInformation(hasLabelInformation).hasProperties(!propertyColumns.isEmpty()).build();
        nodeSubscriber.initialize(subscription.fieldNames(), this.nodesBuilder);
        try {
            CypherLoadingUtils.consume(subscription);
        }
        catch (RuntimeException e) {
            this.nodesBuilder.close(e);
        }
        if (nodeSubscriber.error().isPresent()) {
            this.nodesBuilder.close(nodeSubscriber.error().get());
        }
        if ((rows = nodeSubscriber.rows()) == 0L) {
            this.nodesBuilder.close(new IllegalArgumentException("Node-Query returned no nodes"));
        }
        this.progressTracker.endSubTask("Nodes");
        return new BatchLoadResult(rows, nodeSubscriber.maxId());
    }

    @Override
    void updateCounts(BatchLoadResult result) {
        if (result.maxId() > this.highestNodeId) {
            this.highestNodeId = result.maxId();
        }
    }

    @Override
    IdMapAndProperties result() {
        NodesBuilder.IdMapAndProperties idMapAndProperties = this.nodesBuilder.build(this.highestNodeId);
        IdMap idMap = idMapAndProperties.idMap();
        Map nodeProperties = idMapAndProperties.nodeProperties().orElseGet(Map::of);
        Map<PropertyMapping, NodePropertyValues> nodePropertiesWithPropertyMappings = CypherNodeLoader.propertiesWithPropertyMappings(nodeProperties);
        return IdMapAndProperties.of(idMap, nodePropertiesWithPropertyMappings);
    }

    @Override
    Set<String> getMandatoryColumns() {
        return NodeSubscriber.REQUIRED_COLUMNS;
    }

    @Override
    Set<String> getReservedColumns() {
        return NodeSubscriber.RESERVED_COLUMNS;
    }

    @Override
    CypherRecordLoader.QueryType queryType() {
        return CypherRecordLoader.QueryType.NODE;
    }

    private static Map<PropertyMapping, NodePropertyValues> propertiesWithPropertyMappings(Map<String, NodePropertyValues> properties) {
        return properties.entrySet().stream().collect(Collectors.toMap(propertiesByKey -> PropertyMapping.of((String)((String)propertiesByKey.getKey()), (Object)((NodePropertyValues)propertiesByKey.getValue()).valueType().fallbackValue()), Map.Entry::getValue));
    }
}

