/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.loading;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import org.immutables.value.Value;
import org.neo4j.gds.AbstractNodeProjection;
import org.neo4j.gds.AbstractRelationshipProjection;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.NodeProjection;
import org.neo4j.gds.NodeProjections;
import org.neo4j.gds.PropertyMapping;
import org.neo4j.gds.RelationshipProjection;
import org.neo4j.gds.RelationshipProjections;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.annotation.ValueClass;
import org.neo4j.gds.api.CSRGraphStoreFactory;
import org.neo4j.gds.api.DefaultValue;
import org.neo4j.gds.api.GraphLoaderContext;
import org.neo4j.gds.api.schema.GraphSchema;
import org.neo4j.gds.compat.GraphDatabaseApiProxy;
import org.neo4j.gds.config.GraphProjectConfig;
import org.neo4j.gds.config.GraphProjectFromCypherConfig;
import org.neo4j.gds.core.GraphDimensions;
import org.neo4j.gds.core.GraphDimensionsCypherReader;
import org.neo4j.gds.core.ImmutableGraphDimensions;
import org.neo4j.gds.core.loading.BatchLoadResult;
import org.neo4j.gds.core.loading.CSRGraphStore;
import org.neo4j.gds.core.loading.CSRGraphStoreUtil;
import org.neo4j.gds.core.loading.CountingCypherRecordLoader;
import org.neo4j.gds.core.loading.CypherNodeLoader;
import org.neo4j.gds.core.loading.CypherRecordLoader;
import org.neo4j.gds.core.loading.CypherRelationshipLoader;
import org.neo4j.gds.core.loading.IdMapAndProperties;
import org.neo4j.gds.core.loading.ImmutableEstimationResult;
import org.neo4j.gds.core.loading.ImmutableStaticCapabilities;
import org.neo4j.gds.core.loading.NativeFactory;
import org.neo4j.gds.core.loading.NodeSubscriber;
import org.neo4j.gds.core.loading.RelationshipSubscriber;
import org.neo4j.gds.core.loading.RelationshipsAndProperties;
import org.neo4j.gds.core.utils.mem.MemoryEstimation;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.core.utils.progress.tasks.Task;
import org.neo4j.gds.core.utils.progress.tasks.TaskProgressTracker;
import org.neo4j.gds.core.utils.progress.tasks.Tasks;
import org.neo4j.gds.core.utils.warnings.EmptyUserLogRegistryFactory;
import org.neo4j.gds.transaction.TransactionContext;
import org.neo4j.gds.utils.StringFormatting;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Result;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.internal.kernel.api.security.AccessMode;

public class CypherFactory
extends CSRGraphStoreFactory<GraphProjectFromCypherConfig> {
    private final GraphProjectFromCypherConfig cypherConfig;
    private EstimationResult nodeEstimation;
    private EstimationResult relationshipEstimation;

    public CypherFactory(GraphProjectFromCypherConfig graphProjectConfig, GraphLoaderContext loadingContext) {
        this(graphProjectConfig, loadingContext, (GraphDimensions)new GraphDimensionsCypherReader(loadingContext.transactionContext().withRestrictedAccess(AccessMode.Static.READ), graphProjectConfig, (IdGeneratorFactory)GraphDatabaseApiProxy.resolveDependency((GraphDatabaseService)loadingContext.graphDatabaseService(), IdGeneratorFactory.class)).call());
    }

    public CypherFactory(GraphProjectFromCypherConfig graphProjectConfig, GraphLoaderContext loadingContext, GraphDimensions graphDimensions) {
        super(graphProjectConfig, ImmutableStaticCapabilities.of(true), loadingContext, graphDimensions);
        this.cypherConfig = CypherFactory.getCypherConfig(graphProjectConfig).orElseThrow(() -> new IllegalArgumentException("Expected GraphProjectConfig to be a cypher config."));
    }

    @Override
    public final MemoryEstimation estimateMemoryUsageDuringLoading() {
        return NativeFactory.getMemoryEstimation(this.buildEstimateNodeProjections(), this.buildEstimateRelationshipProjections(), true);
    }

    @Override
    public MemoryEstimation estimateMemoryUsageAfterLoading() {
        return NativeFactory.getMemoryEstimation(this.buildEstimateNodeProjections(), this.buildEstimateRelationshipProjections(), false);
    }

    @Override
    public GraphDimensions estimationDimensions() {
        return ImmutableGraphDimensions.builder().from(this.dimensions).highestPossibleNodeCount(this.getNodeEstimation().estimatedRows()).nodeCount(this.getNodeEstimation().estimatedRows()).relCountUpperBound(this.getRelationshipEstimation().estimatedRows()).build();
    }

    @Override
    protected GraphSchema computeGraphSchema(IdMapAndProperties idMapAndProperties, RelationshipsAndProperties relationshipsAndProperties) {
        return CSRGraphStoreUtil.computeGraphSchema(idMapAndProperties, __ -> idMapAndProperties.properties().keySet(), relationshipsAndProperties);
    }

    @Override
    public CSRGraphStore build() {
        return (CSRGraphStore)this.readOnlyTransaction().apply((tx, ktx) -> {
            BatchLoadResult nodeCount = (BatchLoadResult)new CountingCypherRecordLoader(this.nodeQuery(), CypherRecordLoader.QueryType.NODE, this.cypherConfig, this.loadingContext).load(ktx.internalTransaction());
            this.progressTracker.beginSubTask("Loading");
            IdMapAndProperties idMapAndProperties = (IdMapAndProperties)new CypherNodeLoader(this.nodeQuery(), nodeCount.rows(), this.cypherConfig, this.loadingContext, this.progressTracker).load(ktx.internalTransaction());
            RelationshipsAndProperties relationshipsAndProperties = (RelationshipsAndProperties)new CypherRelationshipLoader(this.relationshipQuery(), idMapAndProperties.idMap(), this.cypherConfig, this.loadingContext, this.progressTracker).load(ktx.internalTransaction());
            CSRGraphStore graphStore = this.createGraphStore(idMapAndProperties, relationshipsAndProperties);
            this.progressTracker.endSubTask("Loading");
            this.logLoadingSummary(graphStore);
            return graphStore;
        });
    }

    @Override
    protected ProgressTracker initProgressTracker() {
        Task task = Tasks.task("Loading", Tasks.leaf("Nodes"), Tasks.leaf("Relationships", this.dimensions.relCountUpperBound()));
        return new TaskProgressTracker(task, this.loadingContext.log(), ((GraphProjectFromCypherConfig)this.graphProjectConfig).readConcurrency(), ((GraphProjectFromCypherConfig)this.graphProjectConfig).jobId(), this.loadingContext.taskRegistryFactory(), EmptyUserLogRegistryFactory.INSTANCE);
    }

    private String nodeQuery() {
        return CypherFactory.getCypherConfig(this.graphProjectConfig).orElseThrow(() -> new IllegalArgumentException("Missing node query")).nodeQuery();
    }

    private String relationshipQuery() {
        return CypherFactory.getCypherConfig(this.graphProjectConfig).orElseThrow(() -> new IllegalArgumentException("Missing relationship query")).relationshipQuery();
    }

    private static Optional<GraphProjectFromCypherConfig> getCypherConfig(GraphProjectConfig config) {
        if (config instanceof GraphProjectFromCypherConfig) {
            return Optional.of((GraphProjectFromCypherConfig)config);
        }
        return Optional.empty();
    }

    private TransactionContext readOnlyTransaction() {
        return this.loadingContext.transactionContext().withRestrictedAccess(AccessMode.Static.READ);
    }

    private EstimationResult getNodeEstimation() {
        if (this.nodeEstimation == null) {
            this.nodeEstimation = this.runEstimationQuery(this.nodeQuery(), NodeSubscriber.RESERVED_COLUMNS);
        }
        return this.nodeEstimation;
    }

    private EstimationResult getRelationshipEstimation() {
        if (this.relationshipEstimation == null) {
            this.relationshipEstimation = this.runEstimationQuery(this.relationshipQuery(), RelationshipSubscriber.RESERVED_COLUMNS);
        }
        return this.relationshipEstimation;
    }

    private EstimationResult runEstimationQuery(String query, Collection<String> reservedColumns) {
        return (EstimationResult)this.readOnlyTransaction().apply((tx, ktx) -> {
            String explainQuery = StringFormatting.formatWithLocale((String)"EXPLAIN %s", (Object[])new Object[]{query});
            try (Result result = tx.execute(explainQuery);){
                Number estimatedRows = (Number)result.getExecutionPlanDescription().getArguments().get("EstimatedRows");
                ArrayList propertyColumns = new ArrayList(result.columns());
                propertyColumns.removeAll(reservedColumns);
                EstimationResult estimationResult = ImmutableEstimationResult.of(estimatedRows.longValue(), propertyColumns.size());
                return estimationResult;
            }
        });
    }

    private NodeProjections buildEstimateNodeProjections() {
        if (this.cypherConfig.isFictitiousLoading()) {
            this.nodeEstimation = ImmutableEstimationResult.of(this.cypherConfig.nodeCount(), 0L);
        }
        NodeProjection nodeProjection = ((AbstractNodeProjection.Builder)NodeProjection.builder().label("*").addAllProperties(this.getNodeEstimation().propertyMappings())).build();
        return NodeProjections.single((NodeLabel)NodeLabel.ALL_NODES, (NodeProjection)nodeProjection);
    }

    private RelationshipProjections buildEstimateRelationshipProjections() {
        if (this.cypherConfig.isFictitiousLoading()) {
            this.relationshipEstimation = ImmutableEstimationResult.of(this.cypherConfig.relationshipCount(), 0L);
        }
        RelationshipProjection relationshipProjection = ((AbstractRelationshipProjection.Builder)RelationshipProjection.builder().type("*").addAllProperties(this.getRelationshipEstimation().propertyMappings())).build();
        return RelationshipProjections.single((RelationshipType)RelationshipType.ALL_RELATIONSHIPS, (RelationshipProjection)relationshipProjection);
    }

    @ValueClass
    static interface EstimationResult {
        public long estimatedRows();

        public long propertyCount();

        @Value.Derived
        default public Map<String, Integer> propertyTokens() {
            return LongStream.range(0L, this.propertyCount()).boxed().collect(Collectors.toMap(Object::toString, property -> -1));
        }

        @Value.Derived
        default public Collection<PropertyMapping> propertyMappings() {
            return LongStream.range(0L, this.propertyCount()).mapToObj(property -> PropertyMapping.of((String)Long.toString(property), (Object)DefaultValue.DEFAULT)).collect(Collectors.toList());
        }
    }
}

