/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.loading;

import java.util.Set;
import org.neo4j.gds.api.GraphLoaderContext;
import org.neo4j.gds.config.GraphProjectFromCypherConfig;
import org.neo4j.gds.core.loading.BatchLoadResult;
import org.neo4j.gds.core.loading.CypherLoadingUtils;
import org.neo4j.gds.core.loading.CypherRecordLoader;
import org.neo4j.gds.core.loading.NodeSubscriber;
import org.neo4j.gds.core.loading.RelationshipSubscriber;
import org.neo4j.gds.core.loading.ResultCountingSubscriber;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;

class CountingCypherRecordLoader
extends CypherRecordLoader<BatchLoadResult> {
    private final CypherRecordLoader.QueryType queryType;
    private long total;

    CountingCypherRecordLoader(String cypherQuery, CypherRecordLoader.QueryType queryType, GraphProjectFromCypherConfig cypherConfig, GraphLoaderContext loadingContext) {
        super(cypherQuery, -1L, cypherConfig, loadingContext);
        this.queryType = queryType;
    }

    @Override
    BatchLoadResult loadSingleBatch(InternalTransaction tx, int bufferSize) {
        ResultCountingSubscriber subscriber = new ResultCountingSubscriber();
        CypherLoadingUtils.consume(this.runLoadingQuery(tx, subscriber));
        return new BatchLoadResult(subscriber.rows(), -1L);
    }

    @Override
    void updateCounts(BatchLoadResult result) {
        this.total += result.rows();
    }

    @Override
    BatchLoadResult result() {
        return new BatchLoadResult(this.total, -1L);
    }

    @Override
    Set<String> getMandatoryColumns() {
        return this.queryType == CypherRecordLoader.QueryType.NODE ? NodeSubscriber.REQUIRED_COLUMNS : RelationshipSubscriber.REQUIRED_COLUMNS;
    }

    @Override
    Set<String> getReservedColumns() {
        return this.queryType == CypherRecordLoader.QueryType.NODE ? NodeSubscriber.RESERVED_COLUMNS : RelationshipSubscriber.RESERVED_COLUMNS;
    }

    @Override
    CypherRecordLoader.QueryType queryType() {
        return this.queryType;
    }
}

