/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.loading;

import java.util.Arrays;
import org.neo4j.gds.core.huge.CompressedAdjacencyList;
import org.neo4j.gds.core.loading.AdjacencyListBuilder;
import org.neo4j.gds.core.loading.BumpAllocator;
import org.neo4j.gds.core.utils.paged.HugeIntArray;
import org.neo4j.gds.core.utils.paged.HugeLongArray;

public final class CompressedAdjacencyListBuilder
implements AdjacencyListBuilder<byte[], CompressedAdjacencyList> {
    private final BumpAllocator<byte[]> builder = new BumpAllocator<byte[]>(Factory.INSTANCE);

    CompressedAdjacencyListBuilder() {
    }

    public Allocator newAllocator() {
        return new Allocator(this.builder.newLocalAllocator());
    }

    public Allocator newPositionalAllocator() {
        return this.newAllocator();
    }

    @Override
    public CompressedAdjacencyList build(HugeIntArray degrees, HugeLongArray offsets) {
        byte[][] intoPages = this.builder.intoPages();
        this.reorder((PAGE[])intoPages, offsets, degrees);
        return new CompressedAdjacencyList(intoPages, degrees, offsets);
    }

    static final class Allocator
    implements AdjacencyListBuilder.Allocator<byte[]> {
        private final BumpAllocator.LocalAllocator<byte[]> allocator;

        private Allocator(BumpAllocator.LocalAllocator<byte[]> allocator) {
            this.allocator = allocator;
        }

        @Override
        public void close() {
        }

        @Override
        public long write(byte[] targets, int length, long address) {
            return this.allocator.insert(targets, length);
        }
    }

    private static enum Factory implements BumpAllocator.Factory<byte[]>
    {
        INSTANCE;


        public byte[][] newEmptyPages() {
            return new byte[0][];
        }

        @Override
        public byte[] newPage(int length) {
            return new byte[length];
        }

        @Override
        public byte[] copyOfPage(byte[] bytes, int length) {
            return Arrays.copyOf(bytes, length);
        }

        @Override
        public int lengthOfPage(byte[] bytes) {
            return bytes.length;
        }
    }
}

