/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.loading;

import org.neo4j.gds.core.loading.RecordsBatchBuffer;
import org.neo4j.gds.core.loading.RelationshipReference;
import org.neo4j.gds.core.loading.RelationshipsBatchBuffer;

public final class CompositeRelationshipsBatchBuffer
extends RecordsBatchBuffer<RelationshipReference> {
    private final RelationshipsBatchBuffer[] buffers;

    private CompositeRelationshipsBatchBuffer(RelationshipsBatchBuffer ... buffers) {
        super(0);
        this.buffers = buffers;
    }

    public static RecordsBatchBuffer<RelationshipReference> of(RelationshipsBatchBuffer ... buffers) {
        if (buffers.length == 1) {
            return buffers[0];
        }
        return new CompositeRelationshipsBatchBuffer(buffers);
    }

    @Override
    public void offer(RelationshipReference record) {
        for (RelationshipsBatchBuffer buffer : this.buffers) {
            buffer.offer(record);
        }
    }

    @Override
    public void reset() {
        for (RelationshipsBatchBuffer buffer : this.buffers) {
            buffer.reset();
        }
    }
}

