/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.loading;

import java.util.List;
import org.neo4j.gds.compat.CompositeNodeCursor;
import org.neo4j.gds.compat.StoreScan;
import org.neo4j.internal.kernel.api.Cursor;
import org.neo4j.internal.kernel.api.NodeLabelIndexCursor;
import org.neo4j.kernel.api.KernelTransaction;

public class CompositeNodeScan
implements StoreScan<CompositeNodeCursor> {
    private final List<StoreScan<NodeLabelIndexCursor>> scans;

    public CompositeNodeScan(List<StoreScan<NodeLabelIndexCursor>> scans) {
        this.scans = scans;
    }

    public synchronized boolean scanBatch(CompositeNodeCursor cursor, KernelTransaction ktx) {
        boolean result = false;
        for (int i = 0; i < this.scans.size(); ++i) {
            NodeLabelIndexCursor indexCursor = cursor.getCursor(i);
            if (indexCursor == null) continue;
            boolean hasNextBatch = this.scans.get(i).scanBatch((Cursor)indexCursor, ktx);
            if (hasNextBatch) {
                result = true;
                continue;
            }
            cursor.removeCursor(i);
        }
        return result;
    }
}

