/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.loading;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.neo4j.gds.collections.DrainingIterator;
import org.neo4j.gds.collections.HugeSparseByteArrayList;
import org.neo4j.gds.collections.HugeSparseCollections;
import org.neo4j.gds.collections.HugeSparseIntList;
import org.neo4j.gds.collections.HugeSparseLongArrayList;
import org.neo4j.gds.collections.HugeSparseLongList;
import org.neo4j.gds.core.loading.VarLongEncoding;
import org.neo4j.gds.core.utils.mem.MemoryEstimation;
import org.neo4j.gds.core.utils.mem.MemoryEstimations;
import org.neo4j.gds.core.utils.mem.MemoryRange;
import org.neo4j.gds.mem.BitUtil;
import org.neo4j.gds.mem.MemoryUsage;
import org.neo4j.gds.utils.StringFormatting;

public final class ChunkedAdjacencyLists {
    private static final byte[] EMPTY_BYTES = new byte[0];
    private static final long[] EMPTY_PROPERTIES = new long[0];
    private final HugeSparseByteArrayList targetLists;
    private final Map<Integer, HugeSparseLongArrayList> properties;
    private final HugeSparseIntList positions;
    private final HugeSparseLongList lastValues;
    private final HugeSparseIntList lengths;

    public static MemoryEstimation memoryEstimation(long avgDegree, long nodeCount, int propertyCount) {
        int deltaBestCase = 1;
        long bestCaseCompressedTargetsSize = ChunkedAdjacencyLists.compressedTargetSize(avgDegree, nodeCount, deltaBestCase);
        long deltaWorstCase = avgDegree > 0L ? BitUtil.ceilDiv((long)nodeCount, (long)avgDegree) : 0L;
        long worstCaseCompressedTargetsSize = ChunkedAdjacencyLists.compressedTargetSize(avgDegree, nodeCount, deltaWorstCase);
        return MemoryEstimations.builder(ChunkedAdjacencyLists.class).fixed("compressed targets", MemoryRange.of((long)bestCaseCompressedTargetsSize, (long)worstCaseCompressedTargetsSize)).fixed("positions", HugeSparseCollections.estimateInt((long)nodeCount, (long)nodeCount)).fixed("lengths", HugeSparseCollections.estimateInt((long)nodeCount, (long)nodeCount)).fixed("lastValues", HugeSparseCollections.estimateLong((long)nodeCount, (long)nodeCount)).fixed("properties", HugeSparseCollections.estimateLongArray((long)nodeCount, (long)nodeCount, (int)((int)avgDegree)).times((long)propertyCount)).build();
    }

    private static long compressedTargetSize(long avgDegree, long nodeCount, long delta) {
        long firstAdjacencyIdAvgByteSize = avgDegree > 0L ? (long)BitUtil.ceilDiv((int)VarLongEncoding.encodedVLongSize(nodeCount), (int)2) : 0L;
        int relationshipByteSize = VarLongEncoding.encodedVLongSize(delta);
        long compressedAdjacencyByteSize = (long)relationshipByteSize * Math.max(0L, avgDegree - 1L);
        return nodeCount * MemoryUsage.sizeOfByteArray((long)(firstAdjacencyIdAvgByteSize + compressedAdjacencyByteSize));
    }

    public static ChunkedAdjacencyLists of(int numberOfProperties, long initialCapacity) {
        return new ChunkedAdjacencyLists(numberOfProperties, initialCapacity);
    }

    private ChunkedAdjacencyLists(int numberOfProperties, long initialCapacity) {
        this.targetLists = HugeSparseByteArrayList.of((byte[])EMPTY_BYTES, (long)initialCapacity);
        this.positions = HugeSparseIntList.of((int)0, (long)initialCapacity);
        this.lastValues = HugeSparseLongList.of((long)0L, (long)initialCapacity);
        this.lengths = HugeSparseIntList.of((int)0, (long)initialCapacity);
        if (numberOfProperties > 0) {
            this.properties = new HashMap<Integer, HugeSparseLongArrayList>(numberOfProperties);
            for (int i = 0; i < numberOfProperties; ++i) {
                this.properties.put(i, HugeSparseLongArrayList.of((long[])EMPTY_PROPERTIES, (long)initialCapacity));
            }
        } else {
            this.properties = null;
        }
    }

    public void add(long index, long[] values, int start, int end, int valuesToAdd) {
        long currentLastValue = this.lastValues.get(index);
        int requiredBytes = 0;
        for (int i = start; i < end; ++i) {
            long delta = values[i] - currentLastValue;
            long compressedValue = VarLongEncoding.zigZag(delta);
            currentLastValue = values[i];
            values[i] = compressedValue;
            requiredBytes += VarLongEncoding.encodedVLongSize(compressedValue);
        }
        int position = this.positions.get(index);
        byte[] compressedTargets = this.ensureCompressedTargetsCapacity(index, position, requiredBytes);
        int newPosition = VarLongEncoding.encodeVLongs(values, start, end, compressedTargets, position);
        this.positions.set(index, newPosition);
        this.lastValues.set(index, currentLastValue);
        this.lengths.addTo(index, valuesToAdd);
    }

    public void add(long index, long[] values, long[][] allProperties, int start, int end, int valuesToAdd) {
        for (int i = 0; i < allProperties.length; ++i) {
            this.addProperties(index, allProperties[i], start, end, i, valuesToAdd);
        }
        this.add(index, values, start, end, valuesToAdd);
    }

    private void addProperties(long index, long[] properties, int start, int end, int propertyIndex, int propertiesToAdd) {
        int length = this.lengths.get(index);
        long[] currentProperties = this.ensurePropertyCapacity(index, length, propertiesToAdd, propertyIndex);
        if (propertiesToAdd == end - start) {
            System.arraycopy(properties, start, currentProperties, length, propertiesToAdd);
        } else {
            int writePos = length;
            for (int i = 0; i < end - start; ++i) {
                currentProperties[writePos++] = properties[start + i];
            }
        }
    }

    private byte[] ensureCompressedTargetsCapacity(long index, int pos, int required) {
        int targetLength = pos + required;
        byte[] compressedTargets = this.targetLists.get(index);
        if (targetLength < 0) {
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Encountered numeric overflow in internal buffer. Was at position %d and needed to grow by %d.", (Object[])new Object[]{pos, required}));
        }
        if (compressedTargets.length <= targetLength) {
            int newLength = BitUtil.nextHighestPowerOfTwo((int)targetLength);
            compressedTargets = Arrays.copyOf(compressedTargets, newLength);
            this.targetLists.set(index, compressedTargets);
        }
        return compressedTargets;
    }

    private long[] ensurePropertyCapacity(long index, int pos, int required, int propertyIndex) {
        int targetLength = pos + required;
        long[] currentProperties = this.properties.get(propertyIndex).get(index);
        if (targetLength < 0) {
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Encountered numeric overflow in internal buffer. Was at position %d and needed to grow by %d.", (Object[])new Object[]{pos, required}));
        }
        if (currentProperties.length <= pos + required) {
            int newLength = BitUtil.nextHighestPowerOfTwo((int)(pos + required));
            currentProperties = Arrays.copyOf(currentProperties, newLength);
            this.properties.get(propertyIndex).set(index, currentProperties);
        }
        return currentProperties;
    }

    public long capacity() {
        return this.targetLists.capacity();
    }

    public boolean contains(long index) {
        return this.targetLists.contains(index);
    }

    public void consume(Consumer consumer) {
        new CompositeDrainingIterator(this.targetLists, this.properties, this.positions, this.lastValues, this.lengths).consume(consumer);
    }

    private static class CompositeDrainingIterator {
        private final DrainingIterator<byte[][]> targetListIterator;
        private final DrainingIterator.DrainingBatch<byte[][]> targetListBatch;
        private final DrainingIterator<int[]> positionsListIterator;
        private final DrainingIterator.DrainingBatch<int[]> positionsListBatch;
        private final DrainingIterator<long[]> lastValuesListIterator;
        private final DrainingIterator.DrainingBatch<long[]> lastValuesListBatch;
        private final DrainingIterator<int[]> lengthsListIterator;
        private final DrainingIterator.DrainingBatch<int[]> lengthsListBatch;
        private final List<DrainingIterator<long[][]>> propertyIterators;
        private final List<DrainingIterator.DrainingBatch<long[][]>> propertyBatches;
        private final long[][] propertiesBuffer;

        CompositeDrainingIterator(HugeSparseByteArrayList targets, Map<Integer, HugeSparseLongArrayList> properties, HugeSparseIntList positions, HugeSparseLongList lastValues, HugeSparseIntList lengths) {
            this.targetListIterator = targets.drainingIterator();
            this.targetListBatch = this.targetListIterator.drainingBatch();
            this.positionsListIterator = positions.drainingIterator();
            this.positionsListBatch = this.positionsListIterator.drainingBatch();
            this.lastValuesListIterator = lastValues.drainingIterator();
            this.lastValuesListBatch = this.lastValuesListIterator.drainingBatch();
            this.lengthsListIterator = lengths.drainingIterator();
            this.lengthsListBatch = this.lengthsListIterator.drainingBatch();
            if (properties == null) {
                this.propertyIterators = List.of();
                this.propertyBatches = List.of();
                this.propertiesBuffer = null;
            } else {
                this.propertyIterators = properties.values().stream().map(HugeSparseLongArrayList::drainingIterator).collect(Collectors.toList());
                this.propertyBatches = this.propertyIterators.stream().map(DrainingIterator::drainingBatch).collect(Collectors.toList());
                this.propertiesBuffer = new long[properties.size()][];
            }
        }

        public void consume(Consumer consumer) {
            while (this.targetListIterator.next(this.targetListBatch)) {
                this.positionsListIterator.next(this.positionsListBatch);
                this.lastValuesListIterator.next(this.lastValuesListBatch);
                this.lengthsListIterator.next(this.lengthsListBatch);
                for (int i = 0; i < this.propertyIterators.size(); ++i) {
                    this.propertyIterators.get(i).next(this.propertyBatches.get(i));
                }
                byte[][] targetsPage = (byte[][])this.targetListBatch.page;
                int[] positionsPage = (int[])this.positionsListBatch.page;
                int[] lengthsPage = (int[])this.lengthsListBatch.page;
                long offset = this.targetListBatch.offset;
                for (int indexInPage = 0; indexInPage < targetsPage.length; ++indexInPage) {
                    byte[] targets = targetsPage[indexInPage];
                    if (targets == EMPTY_BYTES) continue;
                    int position = positionsPage[indexInPage];
                    int length = lengthsPage[indexInPage];
                    for (int propertyIndex = 0; propertyIndex < this.propertyBatches.size(); ++propertyIndex) {
                        long[][] page = (long[][])this.propertyBatches.get((int)propertyIndex).page;
                        this.propertiesBuffer[propertyIndex] = page[indexInPage];
                        page[indexInPage] = null;
                    }
                    targetsPage[indexInPage] = null;
                    consumer.accept(offset + (long)indexInPage, targets, this.propertiesBuffer, position, length);
                }
            }
        }
    }

    public static interface Consumer {
        public void accept(long var1, byte[] var3, long[][] var4, int var5, int var6);
    }
}

